/*
 * Decompiled with CFR 0.152.
 */
package ext.number;

import ext.number.Value;

public class ValLong
extends Value {
    public static final ValLong MIN_VALUE = new ValLong(Long.MIN_VALUE);
    public static final ValLong MAX_VALUE = new ValLong(Long.MAX_VALUE);
    public static final ValLong ZERO = new ValLong(0L);

    public ValLong(long value) {
        this.value = value;
    }

    public ValLong(ValLong src) {
        this(src.value.longValue());
    }

    public ValLong add(Value right) {
        return new ValLong(this.value.longValue() + right.value.longValue());
    }

    public ValLong substract(Value right) {
        return new ValLong(this.value.longValue() - right.value.longValue());
    }

    public int compareTo(Value right) {
        if (this.value.longValue() < right.value.longValue()) {
            return -1;
        }
        if (this.value.longValue() > right.value.longValue()) {
            return 1;
        }
        return 0;
    }

    public ValLong rand() {
        return new ValLong(randomGenerator.nextLong());
    }

    public ValLong rand(Value upperBound) {
        long lowerBoundLong = this.value.longValue();
        long upperBoundLong = upperBound.value.longValue();
        long nextRandomLong = Math.abs(randomGenerator.nextLong());
        long modulus = nextRandomLong % (upperBoundLong - lowerBoundLong + 1L);
        long result = lowerBoundLong + modulus;
        return new ValLong(result);
    }

    public boolean equals(Object right) {
        return right instanceof Value && this.value.longValue() == ((Value)right).value.longValue();
    }

    public ValLong clone() {
        return new ValLong(this);
    }

    public String toString() {
        return "" + this.value;
    }

    public ValLong opposite() {
        return new ValLong(-this.value.longValue());
    }

    public ValLong multiply(Number right) {
        return new ValLong(this.value.longValue() * right.longValue());
    }
}

