/*
 * Decompiled with CFR 0.152.
 */
package jeco.dmm.main;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import jeco.dmm.DMMFitness;
import jeco.dmm.DMMGrammarFilter;
import jeco.dmm.DMMOptimizer;
import jeco.dmm.DMMOptimizerAtienza;
import jeco.dmm.reliableDMM.ChangeProfile;
import jeco.dmm.simulator.DMMCreator;
import jeco.dmm.simulator.DMMHeap;
import jeco.dmm.simulator.DMMLogger;
import jeco.dmm.simulator.layers.AbstractHeap;
import jeco.kernel.algorithm.ge.GrammaticalEvolutionaryAlgorithm;

public class DMMExplore {
    protected METHOD method;
    protected long sizeOfMemoryInKB;
    protected String pathToProfile;
    protected String profilePathMem;
    protected String pathToOutputGrammar;
    protected float minutesPerDMM;
    protected long limit;
    protected long numRegions;
    private static Logger logger = Logger.getLogger(DMMFitness.class.getName());

    public String getMethod() {
        return this.method.toString();
    }

    public DMMExplore(long sizeOfMemoryInKB, String pathToProfile, String profilePathMem, String pathToOutputGrammar, METHOD method, float minutesPerDMM, long limit, long numRegions) throws Exception {
        this.sizeOfMemoryInKB = sizeOfMemoryInKB;
        this.pathToOutputGrammar = pathToOutputGrammar;
        this.method = method;
        this.minutesPerDMM = minutesPerDMM;
        this.limit = limit;
        this.numRegions = numRegions;
        this.pathToProfile = pathToProfile;
        this.profilePathMem = profilePathMem;
        logger.info("Creating grammar...\n");
        DMMGrammarFilter filter = new DMMGrammarFilter(sizeOfMemoryInKB, this.pathToProfile, pathToOutputGrammar);
        filter.getInfo();
        filter.createGrammar();
    }

    public DMMExplore(long sizeOfMemoryInKB, String pathToProfile, String profilePathMem, String pathToOutputGrammar, METHOD method, long limit, long numRegions) throws Exception {
        this(sizeOfMemoryInKB, pathToProfile, profilePathMem, pathToOutputGrammar, method, Float.MAX_VALUE, limit, numRegions);
    }

    public double[] explore() throws Exception {
        Object optimizer;
        double[] fitness = new double[5];
        AbstractHeap heap = null;
        Properties properties = new Properties();
        properties.setProperty("profile_path", this.pathToProfile);
        DMMFitness fitFunction = new DMMFitness();
        fitFunction.setProperties(properties);
        double startTime = System.currentTimeMillis();
        if (this.method == METHOD.KINGSLEY) {
            heap = DMMCreator.buildKingsleyHeap(this.sizeOfMemoryInKB);
        } else if (this.method == METHOD.LEA) {
            heap = DMMCreator.buildLea2_7Heap(this.sizeOfMemoryInKB);
        } else if (this.method == METHOD.ATIENZA) {
            optimizer = new DMMOptimizerAtienza(this.sizeOfMemoryInKB, this.pathToProfile, this.pathToOutputGrammar, this.minutesPerDMM);
            ((DMMOptimizerAtienza)optimizer).execute();
            fitness[4] = ((DMMOptimizerAtienza)optimizer).getVirtualTime();
            heap = fitFunction.composeHeap(((DMMOptimizerAtienza)optimizer).getBestIndividual().getPhenotype());
        } else if (this.method == METHOD.GE || this.method == METHOD.EXTENDEDGE) {
            optimizer = new DMMOptimizer(this.sizeOfMemoryInKB, this.pathToProfile, this.pathToOutputGrammar);
            ((GrammaticalEvolutionaryAlgorithm)optimizer).setProperty("generations", "100");
            ((GrammaticalEvolutionaryAlgorithm)optimizer).setProperty("population_size", "60");
            ((GrammaticalEvolutionaryAlgorithm)optimizer).setProperty("max_depth", "10");
            ((GrammaticalEvolutionaryAlgorithm)optimizer).setProperty("mutation_probability", "0.02");
            ((GrammaticalEvolutionaryAlgorithm)optimizer).setProperty("crossover_probability", "0.8");
            ((DMMOptimizer)optimizer).initialize();
            ((GrammaticalEvolutionaryAlgorithm)optimizer).execute();
            heap = fitFunction.composeHeap(((GrammaticalEvolutionaryAlgorithm)optimizer).getBestFitness().getIndividual().getPhenotype());
        } else {
            throw new Exception("Method: " + (Object)((Object)this.method) + " not implemented yet.");
        }
        double endTime = System.currentTimeMillis();
        double totalTime = (endTime - startTime) / 1000.0;
        DMMHeap.reset();
        DMMLogger.reset();
        logger.info("Collecting statistics and creating accesses files...\n");
        fitFunction.simulate(heap);
        if (this.method != METHOD.ATIENZA) {
            fitness[4] = totalTime;
        }
        fitness[0] = DMMLogger.getExecutionTimeReal() + DMMLogger.getMemoryUsedInHeap() + DMMLogger.getMemUsedByDMMSupport() + DMMLogger.getMemoryAccessesReal();
        fitness[1] = DMMLogger.getExecutionTimeReal();
        fitness[2] = DMMLogger.getMemoryUsedInHeap() + DMMLogger.getMemUsedByDMMSupport();
        fitness[3] = DMMLogger.getMemoryAccessesReal();
        return fitness;
    }

    public static void main(String[] args) {
        LogManager.getLogManager().getLogger("").setLevel(Level.INFO);
        Handler[] handlers = Logger.getLogger("").getHandlers();
        for (int index = 0; index < handlers.length; ++index) {
            handlers[index].setLevel(Level.INFO);
        }
        if (args.length != 7) {
            long memory = (long)(128.0 * Math.pow(2.0, 10.0));
            System.out.println("Memory in KB: " + memory);
            args = new String[]{"ALL", "1", "1", String.valueOf(memory), "test2" + File.separator + "test.profile", "test2" + File.separator + "grammar.bnf", "25"};
            System.out.println("Usage:");
            System.out.println("DMMExplore <KINGSLEY|LEA|ATIENZA#N|GE|EXTENDEDGE|ALL> <NumTrials> <NumBanks> <SizeOfMemoryInKB> <PathToProfile> <PathToOutputGrammar> <AccessesToError>");
            System.out.println("Example: DMMExplore KINGSLEY 1 128 2048 test.profile grammar.bnf 30");
            System.out.println("where:");
            System.out.println("KINGSLEY: Evaluates the application using the KINGSLEY DMM");
            System.out.println("LEA: Evaluates the application using the DOUG LEA DMM");
            System.out.println("ATIENZA#N: Evaluates the application using David's method, where #N is the number of minutes need to evaluate a DMM in his method");
            System.out.println("GE: Evaluates the application using Grammatical Evolution");
            System.out.println("EXTENDEDGE: Evaluates the application using Grammatical Evolution. Taking into account the reliability of memory. Needs splitted profiles.");
            System.out.println("ALL: Evaluates the application using all but the EXTENDED methods (with 3 minutes for David's method, i.e., ATIENZA3 is used)");
            System.out.println("<NumTrials>: Number of trials (It will save an output file for each trial and method).");
            System.out.println("<NumBanks>: How many banks the memory has");
            System.out.println("<SizeOfMemoryInKB>: Memory size (in KB)");
            System.out.println("<PathToProfile>: Relative path to the profiling report");
            System.out.println("<PathToOutputGrammar>: Relative path to the output grammar");
            System.out.println("<AccessesToError>: Number of consecutive accesses permitted before an error occur");
        }
        String method = args[0];
        int numTrials = Integer.valueOf(args[1]);
        int numBanks = Integer.valueOf(args[2]);
        long sizeOfMemoryInKB = Long.valueOf(args[3]);
        String profilePathMem = args[4];
        String pathToOutputGrammar = args[5];
        long limit = Long.valueOf(args[6]);
        String pathToProfile = profilePathMem;
        boolean extendedGE = false;
        String[] temp = pathToProfile.split("\\.", 2);
        if (temp[1].equals("mem")) {
            logger.info("Deleting reads and writes from the profiling...\n");
            pathToProfile = temp[0] + "Temp.profile";
            ChangeProfile toChange = new ChangeProfile();
            toChange.deleteMemInstr(profilePathMem, pathToProfile);
        }
        try {
            ArrayList<DMMExplore> explorers = new ArrayList<DMMExplore>();
            if (method.equals("KINGSLEY") || method.equals("ALL")) {
                explorers.add(new DMMExplore(sizeOfMemoryInKB, pathToProfile, profilePathMem, pathToOutputGrammar, METHOD.KINGSLEY, limit, numBanks));
            }
            if (method.equals("LEA") || method.equals("ALL")) {
                explorers.add(new DMMExplore(sizeOfMemoryInKB, pathToProfile, profilePathMem, pathToOutputGrammar, METHOD.LEA, limit, numBanks));
            }
            if (method.startsWith("ATIENZA") || method.equals("ALL")) {
                if (method.equals("ALL")) {
                    explorers.add(new DMMExplore(sizeOfMemoryInKB, pathToProfile, profilePathMem, pathToOutputGrammar, METHOD.ATIENZA, 3.0f, limit, numBanks));
                } else {
                    if (method.equals("ATIENZA")) {
                        throw new Exception("ATIENZA's method requires the number of minutes need to evaluate a DMM: ATIENZA1 for one minute, ATIENZA2 for two, etc.");
                    }
                    explorers.add(new DMMExplore(sizeOfMemoryInKB, pathToProfile, profilePathMem, pathToOutputGrammar, METHOD.ATIENZA, Float.valueOf(method.substring(7)).floatValue(), limit, numBanks));
                }
            }
            if (method.equals("GE") || method.equals("ALL")) {
                explorers.add(new DMMExplore(sizeOfMemoryInKB, pathToProfile, profilePathMem, pathToOutputGrammar, METHOD.GE, limit, numBanks));
            }
            if (method.equals("EXTENDEDGE")) {
                if (numBanks >= 2) {
                    extendedGE = true;
                } else {
                    throw new Exception("EXTENDEDGE will compute 2 or more memory banks. For 1 bank use GE METHOD.");
                }
            }
            if (explorers.size() == 0 && !extendedGE) {
                throw new Exception("METHOD: " + method + " not recognized.");
            }
            if (extendedGE) {
                int i;
                temp = pathToProfile.split("\\.", 2);
                String pathToProfileTemp = temp[0] + numBanks + "Banks." + temp[1];
                BufferedWriter writer = new BufferedWriter(new FileWriter(new File(pathToProfileTemp + "." + method)));
                double[] totalFitness = new double[5];
                for (i = 0; i < totalFitness.length; ++i) {
                    totalFitness[i] = 0.0;
                }
                sizeOfMemoryInKB /= (long)numBanks;
                for (i = 0; i < numBanks; ++i) {
                    pathToProfileTemp = temp[0] + i + "." + temp[1];
                    logger.info("Processing region " + i + ", profile " + pathToProfileTemp + "...\n");
                    String profilePathMemTemp = pathToProfileTemp;
                    DMMExplore explorer = new DMMExplore(sizeOfMemoryInKB, pathToProfileTemp, profilePathMemTemp, pathToOutputGrammar, METHOD.EXTENDEDGE, limit, numBanks);
                    double[] fitness = explorer.explore();
                    for (int j = 0; j < fitness.length; ++j) {
                        int n = j;
                        totalFitness[n] = totalFitness[n] + fitness[j];
                        writer.write("" + fitness[j] + "\t");
                    }
                    writer.write("\n");
                    writer.flush();
                }
                writer.write("\n\nTOTAL:\n");
                for (int j = 0; j < totalFitness.length; ++j) {
                    writer.write("" + totalFitness[j] + "\t");
                }
                writer.flush();
                writer.close();
            } else {
                for (DMMExplore explorer : explorers) {
                    BufferedWriter writer = new BufferedWriter(new FileWriter(new File(pathToProfile + "." + explorer.getMethod())));
                    for (int i = 0; i < numTrials; ++i) {
                        double[] fitness = explorer.explore();
                        for (int j = 0; j < fitness.length; ++j) {
                            writer.write("" + fitness[j] + "\t");
                        }
                        writer.write("\n");
                        writer.flush();
                    }
                    writer.flush();
                    writer.close();
                }
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum METHOD {
        KINGSLEY,
        LEA,
        ATIENZA,
        GE,
        EXTENDEDGE;

    }
}

