/*
 * Decompiled with CFR 0.152.
 */
package jeco.dmm.main;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import jeco.dmm.simulator.DMMData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DMMProfileGenerator {
    protected String profilePath;
    protected int memorySizeInKB;
    protected ArrayList<Integer> sizesInBytes;

    public DMMProfileGenerator(String profilePath, int memorySizeInKB, ArrayList<Integer> sizesInBytes) {
        this.profilePath = profilePath;
        this.memorySizeInKB = memorySizeInKB;
        this.sizesInBytes = sizesInBytes;
    }

    public void genetateProfile(long numEntries) throws Exception {
        long currentMemAddr = 99999999L + (long)(100000.0 * Math.random());
        BufferedWriter writer = new BufferedWriter(new FileWriter(new File(this.profilePath)));
        ArrayList<DMMData> objectsCreated = new ArrayList<DMMData>();
        double memorySizeInBytes = Math.pow(2.0, 10.0) * (double)this.memorySizeInKB;
        double currentMemorySize = 0.0;
        long i = 0L;
        while (i < numEntries) {
            long size;
            String line = null;
            int randomIndex = (int)(Math.random() * (double)this.sizesInBytes.size());
            if (Math.random() < 0.5) {
                size = this.sizesInBytes.get(randomIndex).intValue();
                if (currentMemorySize + (double)size <= memorySizeInBytes) {
                    String addr1 = Long.toHexString(currentMemAddr++);
                    StringBuffer addr2 = new StringBuffer();
                    for (int k = 0; k < 8 - addr1.length(); ++k) {
                        addr2.append("0");
                    }
                    addr2.append(addr1);
                    DMMData dataObject = new DMMData(addr2.toString(), size);
                    currentMemorySize += (double)size;
                    objectsCreated.add(dataObject);
                    line = "new " + dataObject.getId() + " " + size;
                }
            } else if (objectsCreated.size() > 0) {
                randomIndex = (int)(Math.random() * (double)objectsCreated.size());
                DMMData object = (DMMData)objectsCreated.get(randomIndex);
                objectsCreated.remove(randomIndex);
                size = object.getSizeInBytes();
                currentMemorySize -= (double)size;
                line = "delete " + object.getId() + " " + size;
            }
            if (line == null) continue;
            writer.write(line + "\n");
            ++i;
        }
        writer.flush();
        writer.close();
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("Usage: java -jar DMMProfileGenerator.jar <PathToProfileReport> <NumOfEntries> <MemSizeInKB> <size1 size2 ... sizeN>");
            System.out.println("where:");
            System.out.println("<PathToProfileReport>: Is the relative path to the output profiling report.");
            System.out.println("<NumOfEntries>: Is the number of entries desired (# of allocations/deallocations).");
            System.out.println("<MemSizeInKB>: Is the memory size (in KB).");
            System.out.println("<size1 size2 ... sizeN>: Are the different block sizes (in bytes).");
            int i = 0;
            args = new String[14];
            args[i++] = "test" + File.separator + "test.profile";
            args[i++] = "3000";
            args[i++] = "2048";
            args[i++] = "12";
            args[i++] = "16";
            args[i++] = "24";
            args[i++] = "36";
            args[i++] = "64";
            args[i++] = "128";
            args[i++] = "256";
            args[i++] = "512";
            args[i++] = "1024";
            args[i++] = "1500";
            args[i++] = "3000";
            return;
        }
        String profilePath = args[0];
        long numEntries = Long.valueOf(args[1]);
        int memorySizeInKB = Integer.valueOf(args[2]);
        ArrayList<Integer> sizesInBytes = new ArrayList<Integer>();
        for (int i = 3; i < args.length; ++i) {
            sizesInBytes.add(Integer.valueOf(args[i]));
        }
        DMMProfileGenerator generator = new DMMProfileGenerator(profilePath, memorySizeInKB, sizesInBytes);
        try {
            generator.genetateProfile(numEntries);
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }
}

