/*
 * Decompiled with CFR 0.152.
 */
package jeco.dmm.sim2.lib;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import jeco.dmm.sim2.lib.DynamicMemoryManager;
import jeco.dmm.sim2.lib.Fitness;
import jeco.dmm.sim2.lib.Simulator;
import jeco.dmm.sim2.lib.allocator.Kingsley;
import jeco.dmm.sim2.util.ManagersCreator;
import jeco.dmm.sim2.util.ProfilingReport;
import jeco.kernel.algorithm.ge.GrammaticalEvolutionaryAlgorithm;
import jeco.kernel.util.LoggerFormatter;

public class Explorer {
    private static Logger logger = Logger.getLogger(Explorer.class.getName());
    protected ProfilingReport profile;
    protected METHOD method;
    protected String metrics = null;
    protected String map = null;
    protected String accesses = null;
    protected String grammar = null;

    public Explorer(String pathToProfile, METHOD method, String grammar, String metrics, String map, String accesses) {
        this.profile = new ProfilingReport(pathToProfile);
        try {
            this.profile.load();
        }
        catch (FileNotFoundException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        this.method = method;
        this.grammar = grammar;
        this.metrics = metrics;
        this.map = map;
        this.accesses = accesses;
    }

    public void explore() throws FileNotFoundException, IOException {
        DynamicMemoryManager manager = null;
        Simulator simulator = null;
        double startTime = System.currentTimeMillis();
        if (this.method.equals((Object)METHOD.KINGSLEY)) {
            manager = new DynamicMemoryManager(new Kingsley());
            simulator = new Simulator(this.profile, manager, this.accesses);
        } else if (this.method.equals((Object)METHOD.GE)) {
            Fitness.evaluated.clear();
            Fitness.profilingReport = this.profile;
            GrammaticalEvolutionaryAlgorithm optimizer = new GrammaticalEvolutionaryAlgorithm(this.grammar, Fitness.class.getName());
            optimizer.setProperty("generations", "100");
            optimizer.setProperty("population_size", "60");
            optimizer.setProperty("max_depth", "10");
            optimizer.setProperty("mutation_probability", "0.02");
            optimizer.setProperty("crossover_probability", "0.8");
            logger.info("Initializing gramatical evolution...\n");
            optimizer.initialize();
            logger.info("Executing gramatical evolution...\n");
            optimizer.execute();
            logger.info("done.\n");
            manager = ManagersCreator.buildManagerFromPhenotype(this.profile, optimizer.getBestFitness().getIndividual().getPhenotype());
            simulator = new Simulator(this.profile, manager, this.accesses);
        }
        simulator.initialize();
        simulator.simulate();
        String mapAsString = simulator.drawAllocatorMap();
        String reportAsString = simulator.getMetrics().report();
        logger.info(mapAsString);
        logger.info(reportAsString);
        BufferedWriter writer = null;
        if (this.map != null) {
            logger.info("Saving map ...");
            writer = new BufferedWriter(new FileWriter(new File(this.map)));
            writer.write(mapAsString);
            writer.flush();
            writer.close();
        }
        if (this.metrics != null) {
            logger.info("Saving metrics ...");
            writer = new BufferedWriter(new FileWriter(new File(this.metrics)));
            writer.write(reportAsString);
            writer.flush();
            writer.close();
        }
    }

    public static void main(String[] args) {
        LogManager.getLogManager().getLogger("").setLevel(Level.INFO);
        Handler[] handlers = Logger.getLogger("").getHandlers();
        for (int index = 0; index < handlers.length; ++index) {
            handlers[index].setLevel(Level.INFO);
            handlers[index].setFormatter(LoggerFormatter.formatter);
        }
        if (args.length != 8) {
            args = new String[]{"-profile", "test" + File.separator + "vdrift.mem", "-method", "GE", "-grammar", "test" + File.separator + "vdrift.bnf", "-omode", "MANUAL"};
            System.out.println("Usage:");
            System.out.println("Explorer -profile <profile> -method <method> [-grammar <grammar> -omode <outmode=MANUAL> -ometrics <metrics> -omap <map> -oaccesses <accesses>]");
            System.out.println("Example: Explorer -profile test " + File.separator + "vdrift.mem -method KINGSLEY");
            System.out.println("where:");
            System.out.println("<profile>: Relative path to the profiling report");
            System.out.println("<method>=KINGSLEY: Evaluates the application using the KINGSLEY DMM");
            System.out.println("<method>=GE: Evaluates the application using Grammatical Evolution");
            System.out.println("<gremmar>: Relative path to the grammar file");
            System.out.println("<outmode>=MANUAL: Metrics are saved in the files specified by user (if any)");
            System.out.println("<outmode>=AUTO: All metrics are saved and output file names are named automatically (slowest).");
            System.out.println("<metrics>=File path where the main metrics are saved.");
            System.out.println("<map>=File path where a draw of the DMM is saved.");
            System.out.println("<accesses>=File path where the frecuency of (read/write) accesses is saved.");
        }
        String profile = null;
        String method = null;
        String grammar = null;
        String outmode = "MANUAL";
        String metrics = null;
        String map = null;
        String accesses = null;
        for (int i = 0; i < args.length; i += 2) {
            if (args[i].equals("-profile")) {
                profile = args[i + 1];
                continue;
            }
            if (args[i].equals("-method")) {
                method = args[i + 1];
                continue;
            }
            if (args[i].equals("-grammar")) {
                grammar = args[i + 1];
                continue;
            }
            if (args[i].equals("-omode")) {
                outmode = args[i + 1];
                continue;
            }
            if (args[i].equals("-ometrics")) {
                metrics = args[i + 1];
                continue;
            }
            if (args[i].equals("-omap")) {
                map = args[i + 1];
                continue;
            }
            if (!args[i].equals("-oaccesses")) continue;
            accesses = args[i + 1];
        }
        if (outmode.equals("AUTO")) {
            String baseName = null;
            int pos = profile.lastIndexOf(".");
            baseName = pos < 0 ? profile : profile.substring(0, pos);
            baseName = baseName + "." + method.toString();
            metrics = baseName + ".mtr";
            map = baseName + ".map";
            accesses = baseName + ".acc";
        }
        Explorer explorer = null;
        if (method.equals("KINGSLEY")) {
            explorer = new Explorer(profile, METHOD.KINGSLEY, grammar, metrics, map, accesses);
        } else if (method.equals("GE")) {
            explorer = new Explorer(profile, METHOD.GE, grammar, metrics, map, accesses);
        }
        try {
            explorer.explore();
        }
        catch (FileNotFoundException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum METHOD {
        KINGSLEY,
        GE;

    }
}

