/*
 * Decompiled with CFR 0.152.
 */
package jeco.dmm.sim2.lib.allocator;

import java.util.logging.Logger;
import jeco.dmm.sim2.lib.allocator.SegregatedFit;
import jeco.dmm.sim2.lib.freelist.Block;
import jeco.dmm.sim2.lib.freelist.FreeList;

public abstract class StrictSegregatedFit
extends SegregatedFit {
    private static Logger logger = Logger.getLogger(StrictSegregatedFit.class.getName());

    public StrictSegregatedFit(long minSizeInB, long maxSizeInB, boolean allowSplitting, boolean allowCoalescing) {
        super(minSizeInB, maxSizeInB, allowSplitting, allowCoalescing);
    }

    public Block malloc(long sizeInB, Block hottest) {
        Block newBlock;
        int admIndex = this.computeFreeListIndex(sizeInB);
        if (admIndex < 0) {
            admIndex = 0;
        }
        FreeList adm = (FreeList)this.freeLists.get(admIndex);
        long newSizeInB = adm.getMaxSizeInB();
        this.metrics.incInternalFragmentation(newSizeInB - sizeInB);
        Block block = adm.malloc(newSizeInB, hottest);
        if (block.getPosition() < 0L && (this.allowSplitting || this.allowCoalescing) && (newBlock = this.tryToCoalesceOrSplit(sizeInB)) != null) {
            block = newBlock;
        }
        return block;
    }

    private Block tryToCoalesceOrSplit(long sizeInB) {
        Block block = null;
        if (this.allowSplitting && (block = this.split(sizeInB)) != null) {
            return block;
        }
        if (this.allowCoalescing && (block = this.coalesce(sizeInB)) != null) {
            return block;
        }
        return block;
    }

    public abstract int computeFreeListIndex(long var1);

    public abstract Block coalesce(long var1);

    public abstract Block split(long var1);
}

