/*
 * Decompiled with CFR 0.152.
 */
package jeco.dmm.simulator;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Iterator;
import jeco.dmm.simulator.DMMSizesArray;
import jeco.dmm.simulator.headers.EmptyHeader;
import jeco.dmm.simulator.headers.LeaHeader;
import jeco.dmm.simulator.headers.SizeHeader;
import jeco.dmm.simulator.layers.AbstractHeap;
import jeco.dmm.simulator.layers.coalescing.CoalesceHeap;
import jeco.dmm.simulator.layers.coalescing.CoalesceableHeap;
import jeco.dmm.simulator.layers.combining.HeapList;
import jeco.dmm.simulator.layers.combining.SegHeap2;
import jeco.dmm.simulator.layers.combining.StrictSegHeap2;
import jeco.dmm.simulator.layers.freelists.FIFODLFirstFitHeap;
import jeco.dmm.simulator.layers.freelists.FIFODLFixedListHeap;
import jeco.dmm.simulator.layers.freelists.FIFOSLFixedListHeap;
import jeco.dmm.simulator.layers.root.FixedHeap;
import jeco.dmm.simulator.layers.root.SbrkHeap;
import jeco.dmm.simulator.layers.simple.SingletonHeap;
import jeco.dmm.simulator.layers.simple.SlopHeap;
import jeco.dmm.simulator.selectors.SizeSelector;
import jeco.dmm.simulator.selectors.TrueSelector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DMMCreator {
    public static AbstractHeap buildKingsleyHeap(long maxSizeInKBytes) {
        int numBins;
        int totalNumBins = 29;
        long currentSize = 8L;
        long[] sizes = new long[totalNumBins];
        for (numBins = 0; numBins < totalNumBins; ++numBins) {
            sizes[numBins] = currentSize;
            currentSize *= 2L;
        }
        DMMSizesArray arr = new DMMSizesArray(sizes[--numBins]);
        --numBins;
        while (numBins >= 0) {
            arr = new DMMSizesArray(sizes[numBins], arr);
            --numBins;
        }
        HeapList bigHeap = new HeapList(new FIFODLFirstFitHeap(new SizeHeader()), new TrueSelector(), new TrueSelector(), null);
        bigHeap.setTail(new FixedHeap(new SbrkHeap(new EmptyHeader()), maxSizeInKBytes, new SizeHeader()));
        FIFOSLFixedListHeap littleHeap = new FIFOSLFixedListHeap(new SizeHeader());
        StrictSegHeap2 heapBase = new StrictSegHeap2(arr, littleHeap, bigHeap);
        SingletonHeap heap = new SingletonHeap(heapBase);
        return heap;
    }

    public static AbstractHeap buildLea2_7Heap(long maxSizeInKBytes) {
        long[] fastBins = new long[]{8L, 16L, 24L, 32L, 40L, 48L, 56L, 64L};
        long[] bins = new long[]{8L, 16L, 24L, 32L, 40L, 48L, 56L, 64L, 72L, 80L, 88L, 96L, 104L, 112L, 120L, 128L, 136L, 144L, 152L, 160L, 168L, 176L, 184L, 192L, 200L, 208L, 216L, 224L, 232L, 240L, 248L, 256L, 264L, 272L, 280L, 288L, 296L, 304L, 312L, 320L, 328L, 336L, 344L, 352L, 360L, 368L, 376L, 384L, 392L, 400L, 408L, 416L, 424L, 432L, 440L, 448L, 456L, 464L, 472L, 480L, 488L, 496L, 504L, 512L, 576L, 640L, 704L, 768L, 832L, 896L, 960L, 1024L, 1088L, 1152L, 1216L, 1280L, 1344L, 1408L, 1472L, 1536L, 1600L, 1664L, 1728L, 1792L, 1856L, 1920L, 1984L, 2048L, 2112L, 2560L, 3072L, 3584L, 4096L, 4608L, 5120L, 5632L, 6144L, 6656L, 7168L, 7680L, 8192L, 8704L, 9216L, 9728L, 10240L, 10752L, 12288L, 16384L, 20480L, 24576L, 28672L, 32768L, 36864L, 40960L, 65536L, 98304L, 131072L, 163840L, 262144L, 524288L, 0x100000L, 0x200000L, 0x400000L, 0x800000L, 0x1000000L, 0x2000000L, 0x4000000L, 0x8000000L, 0x10000000L, 0x20000000L, 0x40000000L, 0x80000000L};
        int totalNumBins = bins.length;
        int totalNumFastBins = fastBins.length;
        int numBin = totalNumFastBins - 1;
        DMMSizesArray sizesFastBins = new DMMSizesArray(fastBins[numBin]);
        --numBin;
        while (numBin >= 0) {
            sizesFastBins = new DMMSizesArray(fastBins[numBin], sizesFastBins);
            --numBin;
        }
        numBin = totalNumBins - 1;
        DMMSizesArray sizesBins = new DMMSizesArray(bins[numBin]);
        --numBin;
        while (numBin >= 0) {
            sizesBins = new DMMSizesArray(bins[numBin], sizesBins);
            --numBin;
        }
        FixedHeap tailOS = new FixedHeap(new SbrkHeap(new EmptyHeader()), maxSizeInKBytes, new EmptyHeader());
        CoalesceableHeap bigHeap2 = new CoalesceableHeap(new SlopHeap(tailOS, new LeaHeader()));
        CoalesceHeap bigHeap = new CoalesceHeap(new SegHeap2(sizesBins, new FIFODLFixedListHeap(new LeaHeader()), bigHeap2), 4L, bins[bins.length - 1]);
        StrictSegHeap2 leaHeap = new StrictSegHeap2(sizesFastBins, new FIFOSLFixedListHeap(new LeaHeader()), bigHeap);
        SingletonHeap heap = new SingletonHeap(leaHeap);
        return heap;
    }

    public static AbstractHeap buildCustomAllocator1(int maxSizeInKBytes) {
        FixedHeap tailOS = new FixedHeap(new SbrkHeap(new EmptyHeader()), maxSizeInKBytes, new SizeHeader());
        HeapList heap_one = new HeapList(new FIFOSLFixedListHeap(new SizeHeader()), new TrueSelector(), new TrueSelector(), tailOS);
        SingletonHeap heap = new SingletonHeap(heap_one);
        return heap;
    }

    public static AbstractHeap buildCustomAllocator2(int maxSizeInKBytes) {
        FixedHeap tailOS = new FixedHeap(new SbrkHeap(new EmptyHeader()), maxSizeInKBytes, new SizeHeader());
        HeapList heap_one = new HeapList(new FIFOSLFixedListHeap(new SizeHeader()), new SizeSelector(12L), new SizeSelector(12L), new HeapList(new FIFOSLFixedListHeap(new SizeHeader()), new SizeSelector(16L), new SizeSelector(16L), new HeapList(new FIFOSLFixedListHeap(new SizeHeader()), new SizeSelector(24L), new SizeSelector(24L), new HeapList(new FIFOSLFixedListHeap(new SizeHeader()), new SizeSelector(36L), new SizeSelector(36L), new HeapList(new FIFOSLFixedListHeap(new SizeHeader()), new SizeSelector(64L), new SizeSelector(64L), new HeapList(new FIFOSLFixedListHeap(new SizeHeader()), new SizeSelector(128L), new SizeSelector(128L), new HeapList(new FIFOSLFixedListHeap(new SizeHeader()), new SizeSelector(256L), new SizeSelector(256L), new HeapList(new FIFOSLFixedListHeap(new SizeHeader()), new SizeSelector(512L), new SizeSelector(512L), new HeapList(new FIFOSLFixedListHeap(new SizeHeader()), new SizeSelector(1024L), new SizeSelector(1024L), new HeapList(new FIFOSLFixedListHeap(new SizeHeader()), new SizeSelector(1500L), new SizeSelector(1500L), new HeapList(new FIFOSLFixedListHeap(new SizeHeader()), new SizeSelector(3000L), new SizeSelector(3000L), new HeapList(new FIFOSLFixedListHeap(new SizeHeader()), new TrueSelector(), new TrueSelector(), tailOS))))))))))));
        SingletonHeap heap = new SingletonHeap(heap_one);
        return heap;
    }

    public static AbstractHeap buildCustomAllocator(ArrayList<String> symbols) throws Exception {
        Iterator<String> itr = symbols.iterator();
        AbstractHeap heap = null;
        String className = itr.next();
        heap = (AbstractHeap)DMMCreator.composeComplexObject(className, itr);
        return heap;
    }

    private static Object composeComplexObject(String currentSymbol, Iterator<String> itr) throws Exception {
        int i;
        Object object = null;
        String className = currentSymbol.substring(0, currentSymbol.length() - 1);
        Class<?> objectClass = Class.forName(className);
        Constructor<?>[] constructors = objectClass.getConstructors();
        String nextSymbol = itr.next();
        ArrayList<Object> parameters = DMMCreator.composeParameters(nextSymbol, itr);
        for (i = 0; i < constructors.length && constructors[i].getParameterTypes().length != parameters.size(); ++i) {
        }
        Object[] parametersAsArray = new Object[parameters.size()];
        for (int j = 0; j < parameters.size(); ++j) {
            parametersAsArray[j] = parameters.get(j);
        }
        object = constructors[i].newInstance(parametersAsArray);
        return object;
    }

    private static Object composeSimpleObject(String className) throws Exception {
        Integer object = null;
        try {
            Class<?> objectClass = Class.forName(className);
            object = objectClass.newInstance();
        }
        catch (ClassNotFoundException ee) {
            object = Integer.valueOf(className);
        }
        return object;
    }

    private static ArrayList<Object> composeParameters(String currentSymbol, Iterator<String> itr) throws Exception {
        ArrayList<Object> parameters = new ArrayList<Object>();
        if (currentSymbol.equals(",")) {
            currentSymbol = itr.next();
            parameters.addAll(DMMCreator.composeParameters(currentSymbol, itr));
        } else if (!currentSymbol.equals(")")) {
            if (currentSymbol.endsWith("(")) {
                parameters.add(DMMCreator.composeComplexObject(currentSymbol, itr));
                if (itr.hasNext()) {
                    currentSymbol = itr.next();
                    parameters.addAll(DMMCreator.composeParameters(currentSymbol, itr));
                }
            } else {
                parameters.add(DMMCreator.composeSimpleObject(currentSymbol));
                if (itr.hasNext()) {
                    currentSymbol = itr.next();
                    parameters.addAll(DMMCreator.composeParameters(currentSymbol, itr));
                }
            }
        }
        return parameters;
    }
}

