/*
 * Decompiled with CFR 0.152.
 */
package jeco.dmm.simulator.layers.coalescing;

import jeco.dmm.simulator.DMMBlock;
import jeco.dmm.simulator.DMMData;
import jeco.dmm.simulator.DMMHeap;
import jeco.dmm.simulator.DMMLogger;
import jeco.dmm.simulator.headers.LeaHeader;
import jeco.dmm.simulator.layers.AbstractHeap;

public class CoalesceHeap
extends AbstractHeap {
    protected long minSize;
    protected long maxSize;
    protected AbstractHeap child;

    public CoalesceHeap(AbstractHeap child, long minSize, long maxSize) {
        super(child.getHeader());
        DMMLogger.updateData(4L, 9L, 3L, 0L);
        DMMLogger.addMemUsedByDMMSupport(17L);
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.child = child;
    }

    public DMMBlock free(DMMData dataObject) {
        DMMLogger.updateData(9L, 24L, 0L, 9L);
        DMMBlock block = DMMHeap.findBlock(dataObject.getId());
        LeaHeader blockHeader = (LeaHeader)block.getHeader();
        DMMBlock prevBlock = block.getPrevInHeap();
        if (prevBlock != null) {
            DMMLogger.updateData(3L, 14L, 0L, 5L);
            LeaHeader prevBlockHeader = (LeaHeader)prevBlock.getHeader();
            long newSize = blockHeader.getDataSize() + prevBlockHeader.getDataSize() + (long)this.header.getMaxSizeInBytes();
            if (!blockHeader.isPrevUsed() && newSize <= this.maxSize) {
                DMMLogger.updateData(1L, 4L, 0L, 1L);
                if (this.child.remove(prevBlock.getDataObject())) {
                    DMMLogger.updateData(1L, 4L, 0L, 0L);
                    block = this.coalesce(prevBlock, block);
                }
            }
        }
        blockHeader = (LeaHeader)block.getHeader();
        DMMBlock nextBlock = block.getNextInHeap();
        if (nextBlock != null) {
            DMMLogger.updateData(3L, 12L, 0L, 5L);
            LeaHeader nextBlockHeader = (LeaHeader)nextBlock.getHeader();
            long newSize = blockHeader.getDataSize() + nextBlockHeader.getDataSize() + (long)this.header.getMaxSizeInBytes();
            if (nextBlock.getNextInHeap() != null) {
                DMMLogger.updateData(1L, 5L, 0L, 3L);
                if (!((LeaHeader)nextBlock.getNextInHeap().getHeader()).isPrevUsed() && newSize <= this.maxSize) {
                    DMMLogger.updateData(1L, 4L, 0L, 2L);
                    if (this.child.remove(nextBlock.getDataObject())) {
                        DMMLogger.updateData(1L, 4L, 0L, 0L);
                    }
                    block = this.coalesce(block, nextBlock);
                }
            }
        }
        ((LeaHeader)block.getNextInHeap().getHeader()).setPrevUsed(false);
        return this.child.free(block.getDataObject());
    }

    protected DMMBlock coalesce(DMMBlock first, DMMBlock second) {
        LeaHeader firstHeader = (LeaHeader)first.getHeader();
        LeaHeader secondHeader = (LeaHeader)second.getHeader();
        long newSize = firstHeader.getDataSize() + secondHeader.getDataSize() + (long)this.header.getMaxSizeInBytes();
        if (DMMHeap.remove(second)) {
            DMMLogger.updateData(4L, 13L, 0L, 6L);
            first.getDataObject().setSizeInBytes(newSize);
            firstHeader.setDataSize(newSize);
            ((LeaHeader)first.getNextInHeap().getHeader()).setPrevDataSize(newSize);
            return first;
        }
        System.err.println("Return null from CoalesceHeap.");
        DMMLogger.addInfinity();
        return null;
    }

    public DMMBlock malloc(DMMData dataObject) {
        DMMLogger.updateData(5L, 11L, 0L, 2L);
        DMMBlock block = this.child.malloc(dataObject);
        if (block != null) {
            DMMLogger.updateData(3L, 10L, 0L, 4L);
            ((LeaHeader)block.getNextInHeap().getHeader()).setPrevUsed(true);
            DMMBlock splitPiece = this.split(block, dataObject.getSizeInBytes());
            if (splitPiece != null) {
                DMMLogger.updateData(2L, 8L, 0L, 5L);
                ((LeaHeader)splitPiece.getNextInHeap().getHeader()).setPrevUsed(false);
                this.child.free(splitPiece.getDataObject());
            }
        }
        return block;
    }

    protected DMMBlock split(DMMBlock block, long requestedSize) {
        DMMLogger.updateData(3L, 13L, 0L, 3L);
        LeaHeader actualHeader = (LeaHeader)block.getHeader();
        long actualSize = actualHeader.getDataSize();
        if (actualSize - requestedSize >= (long)this.header.getMaxSizeInBytes() + this.minSize && requestedSize >= this.minSize) {
            DMMLogger.updateData(11L, 37L, 0L, 12L);
            actualHeader.setDataSize(requestedSize);
            block.getDataObject().setSizeInBytes(requestedSize);
            long newSize = actualSize - requestedSize - (long)this.header.getMaxSizeInBytes();
            DMMData newObject = new DMMData(null, newSize);
            LeaHeader headerNewObject = new LeaHeader();
            DMMLogger.redoDataReal(1L, 2L, headerNewObject.getMaxSizeInBytes(), 0L);
            DMMBlock newBlock = new DMMBlock(headerNewObject, newObject);
            int indexOfBlock = DMMHeap.getIndex(block.getDataId());
            DMMHeap.add(newBlock, ++indexOfBlock);
            LeaHeader headerNewBlock = (LeaHeader)newBlock.getHeader();
            headerNewBlock.setDataSize(newSize);
            LeaHeader headerNext = (LeaHeader)newBlock.getNextInHeap().getHeader();
            headerNext.setPrevDataSize(newSize);
            headerNewBlock.setPrevDataSize(requestedSize);
            headerNext.setPrevUsed(true);
            headerNewBlock.setPrevUsed(true);
            return newBlock;
        }
        DMMLogger.updateData(1L, 0L, 0L, 0L);
        return null;
    }

    public boolean remove(DMMData dataObject) {
        System.err.println("Error remove CoalesceableHeap");
        DMMLogger.addInfinity();
        return false;
    }
}

