/*
 * Decompiled with CFR 0.152.
 */
package jeco.dmm.simulator.layers.freelists;

import jeco.dmm.simulator.DMMBlock;
import jeco.dmm.simulator.DMMLogger;
import jeco.dmm.simulator.headers.AbstractHeader;
import jeco.dmm.simulator.layers.AbstractHeap;

public abstract class AbstractFreeList
extends AbstractHeap {
    protected DMMBlock head;
    protected DMMBlock tail;

    public AbstractFreeList(AbstractHeader header) {
        super(header);
        DMMLogger.updateData(3L, 4L, 2L, 0L);
        DMMLogger.addMemUsedByDMMSupport(2L);
        this.tail = null;
        this.head = null;
    }

    public boolean isEmpty() {
        DMMLogger.updateData(1L, 1L, 0L, 0L);
        return this.head == null && this.tail == null;
    }

    public DMMBlock getFront() {
        DMMLogger.updateData(1L, 1L, 0L, 0L);
        return this.head;
    }

    public String blockSizesToString() {
        StringBuffer buffer = new StringBuffer();
        for (DMMBlock block = this.head; block != null; block = block.getNext()) {
            buffer.append(block.getTotalSizeInBytes() + ";");
        }
        return buffer.toString();
    }

    public String printList() {
        String s = "";
        DMMBlock block = this.head;
        if (this.head != null) {
            s = s + "\n First:" + this.head.getDataId();
        }
        if (this.tail != null) {
            s = s + " -- Last: " + this.tail.getDataId();
        }
        while (block != null) {
            s = s + "\n" + block.getDataId();
            s = block.getPrev() != null ? s + ":\n\tPrev = " + block.getPrev().getDataId() : s + ":\n\tPrev = NULL";
            s = block.getNext() != null ? s + ":\n\tNext = " + block.getNext().getDataId() : s + ":\n\tNext = NULL";
            block = block.getNext();
        }
        System.out.println(s);
        return s;
    }
}

