/*
 * Decompiled with CFR 0.152.
 */
package jeco.kernel.algorithm;

import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import jeco.kernel.problem.Problem;
import jeco.kernel.problem.Solutions;
import jeco.kernel.util.LoggerFormatter;

public abstract class Algorithm {
    protected String name;
    protected Problem problem;

    public String getName() {
        return this.name;
    }

    public Problem getProblem() {
        return this.problem;
    }

    public void setProblem(Problem problem) {
        this.problem = problem;
    }

    public Algorithm(String name, Problem problem) {
        this.name = name;
        this.problem = problem;
        this.setLevel(Level.INFO);
    }

    public void setLevel(Level level) {
        Handler[] handlers = Logger.getLogger("").getHandlers();
        for (int index = 0; index < handlers.length; ++index) {
            handlers[index].setLevel(level);
            handlers[index].setFormatter(LoggerFormatter.formatter);
        }
    }

    public abstract void initialize();

    public abstract Solutions execute();

    public abstract void step();
}

