/*
 * Decompiled with CFR 0.152.
 */
package jeco.kernel.algorithm.moga;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.logging.Logger;
import jeco.kernel.algorithm.Algorithm;
import jeco.kernel.operator.assigner.CrowdingDistance;
import jeco.kernel.operator.assigner.FrontsExtractor;
import jeco.kernel.operator.comparator.ComparatorNSGAII;
import jeco.kernel.operator.comparator.SolutionDominance;
import jeco.kernel.operator.crossover.CrossoverOperator;
import jeco.kernel.operator.mutator.MutationOperator;
import jeco.kernel.operator.selector.SelectionOperator;
import jeco.kernel.problem.Problem;
import jeco.kernel.problem.Solution;
import jeco.kernel.problem.Solutions;

public class NSGAII
extends Algorithm {
    private static Logger logger = Logger.getLogger(NSGAII.class.getName());
    protected int maxGenerations;
    protected int maxPopulationSize;
    protected Comparator<Solution> dominance;
    protected int currentGeneration;
    protected Solutions population;
    protected MutationOperator mutationOperator;
    protected CrossoverOperator crossoverOperator;
    protected SelectionOperator selectionOperator;

    public NSGAII(Problem problem, int maxPopulationSize, int maxGenerations, MutationOperator mutationOperator, CrossoverOperator crossoverOperator, SelectionOperator selectionOperator) {
        super("NSGAII", problem);
        this.maxPopulationSize = maxPopulationSize;
        this.maxGenerations = maxGenerations;
        this.mutationOperator = mutationOperator;
        this.crossoverOperator = crossoverOperator;
        this.selectionOperator = selectionOperator;
    }

    public void initialize() {
        this.dominance = new SolutionDominance();
        this.population = this.problem.newRandomSetOfSolutions(this.maxPopulationSize);
        for (Solution solution : this.population) {
            this.problem.evaluate(solution);
            this.problem.evaluateConstraints(solution);
        }
        CrowdingDistance assigner = new CrowdingDistance(this.problem.getNumberOfObjectives());
        assigner.execute(this.population);
        this.currentGeneration = 0;
    }

    public Solutions execute() {
        int nextPercentageReport = 10;
        while (this.currentGeneration < this.maxGenerations) {
            this.step();
            int percentage = Math.round(this.currentGeneration * 100 / this.maxGenerations);
            if (percentage != nextPercentageReport) continue;
            logger.info(percentage + "% performed ...");
            nextPercentageReport += 10;
        }
        this.population.keepParetoNonDominated(this.dominance);
        return this.population;
    }

    public void step() {
        ++this.currentGeneration;
        if (this.population.size() < 2) {
            logger.info("Generation: " + this.currentGeneration + ". Population size is less than 2. Generating two solutions");
            this.population = this.problem.newRandomSetOfSolutions(2);
            for (Solution solution : this.population) {
                this.problem.evaluate(solution);
                this.problem.evaluateConstraints(solution);
            }
        }
        Solutions childPop = new Solutions();
        for (int i = 0; i < this.maxPopulationSize / 2; ++i) {
            Solution parent1 = this.selectionOperator.execute(this.population);
            Solution parent2 = this.selectionOperator.execute(this.population);
            Solution[] offSpring = this.crossoverOperator.execute(parent1, parent2);
            for (int j = 0; j < offSpring.length; ++j) {
                this.mutationOperator.execute(offSpring[j]);
                this.problem.evaluate(offSpring[j]);
                this.problem.evaluateConstraints(offSpring[j]);
                childPop.add(offSpring[j]);
            }
        }
        Solutions mixedPop = new Solutions();
        mixedPop.addAll(this.population);
        mixedPop.addAll(childPop);
        this.population = this.reduce(mixedPop, this.maxPopulationSize);
    }

    public Solutions reduce(Solutions pop, int maxSize) {
        FrontsExtractor extractor = new FrontsExtractor(this.dominance);
        ArrayList<Solutions> fronts = extractor.execute(pop);
        Solutions reducedPop = new Solutions();
        CrowdingDistance assigner = new CrowdingDistance(this.problem.getNumberOfObjectives());
        for (int i = 0; reducedPop.size() < maxSize && i < fronts.size(); ++i) {
            Solutions front = fronts.get(i);
            assigner.execute(front);
            reducedPop.addAll(front);
        }
        ComparatorNSGAII comparator = new ComparatorNSGAII();
        if (reducedPop.size() > maxSize) {
            Collections.sort(reducedPop, comparator);
            while (reducedPop.size() > maxSize) {
                reducedPop.remove(reducedPop.size() - 1);
            }
        }
        return reducedPop;
    }

    public void setMutationOperator(MutationOperator mutationOperator) {
        this.mutationOperator = mutationOperator;
    }

    public void setCrossoverOperator(CrossoverOperator crossoverOperator) {
        this.crossoverOperator = crossoverOperator;
    }

    public void setSelectionOperator(SelectionOperator selectionOperator) {
        this.selectionOperator = selectionOperator;
    }

    public void setMaxGenerations(int maxGenerations) {
        this.maxGenerations = maxGenerations;
    }

    public void setMaxPopulationSize(int maxPopulationSize) {
        this.maxPopulationSize = maxPopulationSize;
    }
}

