/*
 * Decompiled with CFR 0.152.
 */
package jeco.kernel.operator.mutator;

import jeco.kernel.operator.mutator.MutationOperator;
import jeco.kernel.problem.Solution;
import jeco.kernel.problem.Variable;
import jeco.kernel.problem.VariableReal;
import jeco.kernel.util.RandomGenerator;

public class PolynomialMutation
extends MutationOperator {
    public static final double DEFAULT_ETA_M = 20.0;
    public static final double DEFAULT_PROBABILITY = 0.01;
    protected double eta_m;
    protected double probability;

    public PolynomialMutation() {
        this.eta_m = 20.0;
        this.probability = 0.01;
    }

    public PolynomialMutation(double eta_m, double probability) {
        this.eta_m = eta_m;
        this.probability = probability;
    }

    public Solution execute(Solution solution) {
        Variable[] variables = solution.getVariables();
        for (int i = 0; i < variables.length; ++i) {
            double deltaq;
            double val;
            double xy;
            VariableReal variable = (VariableReal)variables[i];
            if (!(RandomGenerator.nextDouble() <= this.probability)) continue;
            double y = (Double)variable.getValue();
            double yl = (Double)variable.getLowerBound();
            double yu = (Double)variable.getUpperBound();
            double delta1 = (y - yl) / (yu - yl);
            double delta2 = (yu - y) / (yu - yl);
            double rnd = RandomGenerator.nextDouble();
            double mut_pow = 1.0 / (this.eta_m + 1.0);
            if (rnd <= 0.5) {
                xy = 1.0 - delta1;
                val = 2.0 * rnd + (1.0 - 2.0 * rnd) * Math.pow(xy, this.eta_m + 1.0);
                deltaq = Math.pow(val, mut_pow) - 1.0;
            } else {
                xy = 1.0 - delta2;
                val = 2.0 * (1.0 - rnd) + 2.0 * (rnd - 0.5) * Math.pow(xy, this.eta_m + 1.0);
                deltaq = 1.0 - Math.pow(val, mut_pow);
            }
            y += deltaq * (yu - yl);
            if (y < yl) {
                y = yl;
            }
            if (y > yu) {
                y = yu;
            }
            variable.setValue(y);
        }
        return solution;
    }
}

