/*
 * Decompiled with CFR 0.152.
 */
package jeco.kernel.operator.replacement;

import java.util.Collections;
import jeco.kernel.operator.comparator.SolutionDominance;
import jeco.kernel.problem.Solutions;

public class ReplacementOperation {
    protected int replacementSize;
    protected double valueD;
    protected REPLACEMENT_TYPE replacementType;

    public ReplacementOperation(int replacementSize) {
        this.replacementSize = replacementSize;
        this.valueD = -1.0;
    }

    public ReplacementOperation(double valueD) throws Exception {
        if (valueD < 0.0 || valueD > 1.0) {
            throw new Exception("valueD must be in the range [0,1]");
        }
        this.replacementSize = -1;
        this.valueD = valueD;
    }

    public ReplacementOperation(REPLACEMENT_TYPE replacementType) {
        this.replacementSize = -1;
        this.valueD = -1.0;
        this.replacementType = replacementType;
    }

    public ReplacementOperation() {
        this(REPLACEMENT_TYPE.GENERATIONAL);
    }

    public Solutions execute(Solutions arg) {
        Solutions solutions = new Solutions();
        solutions.addAll(arg);
        int popSize = solutions.size();
        if (this.replacementSize <= 0) {
            if (this.valueD >= 0.0) {
                this.replacementSize = (int)((double)popSize * this.valueD);
            } else if (this.replacementType.equals((Object)REPLACEMENT_TYPE.STEADY_STATE)) {
                this.valueD = 1.0 / (double)popSize;
                this.replacementSize = (int)((double)popSize * this.valueD);
            } else if (this.replacementType.equals((Object)REPLACEMENT_TYPE.GENERATIONAL)) {
                this.valueD = 1.0;
                this.replacementSize = (int)((double)popSize * this.valueD);
            }
        }
        SolutionDominance comparator = new SolutionDominance();
        Collections.sort(solutions, comparator);
        for (int i = 0; i < this.replacementSize; ++i) {
            solutions.remove(solutions.size() - 1);
        }
        return solutions;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum REPLACEMENT_TYPE {
        STEADY_STATE,
        GENERATIONAL;

    }
}

