/*
 * Decompiled with CFR 0.152.
 */
package jeco.lib.problems.floorplan;

import jeco.kernel.operator.mutator.MutationOperator;
import jeco.kernel.problem.Solution;
import jeco.kernel.problem.Variable;
import jeco.kernel.util.RandomGenerator;
import jeco.lib.problems.floorplan.Component;

public class PostfixVariable
extends Variable {
    protected Component component;
    protected int maxChainLength;
    protected int chainType;
    protected int chainLength;
    protected static final String[] chains = new String[]{"VHVHVHVHVHVHVHVHVHVHVHVHVHVHVHVHVHVHVHVHVHVHVHVHVHVHVHVHVHVHVHVHVHVHVHVHVHVHVHVHVHVHVHVHVHVHVHVH", "HVHVHVHVHVHVHVHVHVHVHVHVHVHVHVHVHVHVHVHVHVHVHVHVHVHVHVHVHVHVHVHVHVHVHVHVHVHVHVHVHVHVHVHVHVHVHVHV", "ZHZVZHZVZHZVZHZVZHZVZHZVZHZVZHZVZHZVZHZVZHZVZHZVZHZVZHZVZHZVZHZVZHZVZHZVZHZVZHZVZHZVZHZVZHZVZHZV"};

    public PostfixVariable(Component component, int maxChainLength) {
        this.component = component;
        this.maxChainLength = maxChainLength;
        this.chainType = RandomGenerator.nextInt(chains.length);
        this.chainLength = RandomGenerator.nextDouble() < 0.5 ? 0 : this.poisson(3.0);
        if (this.chainLength > maxChainLength) {
            this.chainLength = maxChainLength;
        }
    }

    public Variable clone() {
        PostfixVariable clone = new PostfixVariable(this.component, this.maxChainLength);
        clone.component = this.component.clone();
        clone.chainType = this.chainType;
        clone.chainLength = this.chainLength;
        return clone;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.component.id);
        if (this.chainLength > 0) {
            buffer.append(chains[this.chainType].substring(0, this.chainLength));
        }
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        PostfixVariable right = (PostfixVariable)obj;
        return this.component.id == right.component.id;
    }

    private int poisson(double mean) {
        double stop = Math.exp(-mean);
        double prod = 1.0;
        prod *= RandomGenerator.nextDouble();
        int k = 1;
        while (prod >= stop) {
            prod *= RandomGenerator.nextDouble();
            ++k;
        }
        return k - 1;
    }

    public static class PostfixMutation
    extends MutationOperator {
        public Solution execute(Solution object) {
            Solution solution = object;
            int size = solution.getVariables().length;
            for (int i = 0; i < size; ++i) {
                PostfixVariable varI = (PostfixVariable)solution.getVariable(i);
                double random = RandomGenerator.nextDouble();
                if (random < 0.25) {
                    int j = RandomGenerator.nextInt(size);
                    PostfixVariable varJ = (PostfixVariable)solution.getVariable(j);
                    Component temp = varI.component;
                    varI.component = varJ.component;
                    varJ.component = temp;
                    continue;
                }
                if (random < 0.5) {
                    varI.chainType = (varI.chainType + 1) % chains.length;
                    continue;
                }
                if (random < 0.75) {
                    varI.chainLength = RandomGenerator.nextDouble() < 0.5 ? ++varI.chainLength : --varI.chainLength;
                    if (varI.chainLength < 0) {
                        varI.chainLength = 0;
                    }
                    if (varI.chainLength <= varI.maxChainLength) continue;
                    varI.chainLength = varI.maxChainLength;
                    continue;
                }
                if (!(random < 1.0)) continue;
                Integer temp = varI.component.l;
                varI.component.l = varI.component.w;
                varI.component.w = temp;
            }
            return solution;
        }
    }
}

