/*
 * Decompiled with CFR 0.152.
 */
package moea.moga.algorithms;

import java.util.Collections;
import java.util.HashSet;
import moea.commons.Population;
import moea.commons.comparator.ComparatorFitness;
import moea.commons.comparator.ComparatorPareto;
import moea.moga.algorithms.Moea;
import moea.moga.genome.Chromosome;
import moea.moga.selector.VegaTournamentSelector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Vega
extends Moea {
    public Vega(String name, Population<Chromosome> popIni, int maxGenerations, double probabilityOfCrossover, double probabilityOfMutation, int migrationRate) {
        super(name, popIni, maxGenerations, probabilityOfCrossover, probabilityOfMutation, migrationRate);
        this.selector = new VegaTournamentSelector(ComparatorFitness.getInstance());
    }

    public Vega(String name, Population<Chromosome> popIni, int maxGenerations, double probabilityOfCrossover, double probabilityOfMutation) {
        this(name, popIni, maxGenerations, probabilityOfCrossover, probabilityOfMutation, 1);
    }

    @Override
    public void step() {
        int extSize = this.externalIndividuals.size();
        if (extSize > 0) {
            for (int i = 0; i < extSize; ++i) {
                this.pop.add(this.externalIndividuals.get(i));
            }
            this.externalIndividuals.clear();
            this.pop = this.fix(this.pop);
        }
        this.pop = this.generate(this.pop);
        ++this.currentGeneration;
    }

    public synchronized Population<Chromosome> fix(Population<Chromosome> pop) {
        Population<Chromosome> newPop = new Population<Chromosome>();
        double currentAll = Double.MAX_VALUE;
        double currentInd = Double.MAX_VALUE;
        HashSet<Integer> indexes = new HashSet<Integer>();
        Collections.sort(pop, ComparatorPareto.getInstance());
        Chromosome ind = null;
        for (int i = 0; i < pop.size(); ++i) {
            ind = (Chromosome)pop.get(i);
            currentInd = (Double)ind.getObjectiveVector().get(0);
            if (currentAll == currentInd) continue;
            newPop.add(ind);
            indexes.add(i);
            if (newPop.size() == this.popSizeMax) break;
            currentAll = currentInd;
        }
        int diff = this.popSizeMax - newPop.size();
        int k = 0;
        while (diff > 0) {
            ind = (Chromosome)pop.get(k);
            if (!indexes.contains(k)) {
                newPop.add(ind);
                --diff;
            }
            ++k;
        }
        return newPop;
    }
}

