/*
 * Decompiled with CFR 0.152.
 */
package moea.moga.examples;

import ext.number.ValInt;
import ext.number.ValLong;
import ext.number.Value;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import moea.commons.ObjectiveVector;
import moea.commons.Population;
import moea.moga.algorithms.Moea;
import moea.moga.algorithms.Nsga2;
import moea.moga.algorithms.Spea2;
import moea.moga.algorithms.Vega;
import moea.moga.genome.Chromosome;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileChristosV2
extends Chromosome {
    private static final long serialVersionUID = 1L;
    public static final int NOTHING = 0;
    public static final int AR = 1;
    public static final int ARP = 2;
    public static final int SLL = 3;
    public static final int DLL = 4;
    public static final int SLLO = 5;
    public static final int DLLO = 6;
    public static final String[] ddts = new String[]{"NOTHING", "AR", "ARP", "SLL", "DLL", "SLLO", "DLLO"};
    public static long[] Ne;
    public static double[] NeSd;
    public static double[] Nve;
    public static int[] Te;
    public static int Tref;
    public static long[] reads;
    public static long[] writes;

    public static void initializeProblem(String proPath) {
        Element xmlProfileAnalyzer = null;
        try {
            File file = new File(proPath);
            if (!file.exists()) {
                throw new Exception("The file path does not exist.");
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document docApplication = builder.parse(file.toURI().toString());
            xmlProfileAnalyzer = (Element)docApplication.getElementsByTagName("ProfileAnalyzer").item(0);
            N = 3;
            M = 5 * ProfileChristosV2.loadScalarAsInteger(xmlProfileAnalyzer, "VarCount");
            Tref = ProfileChristosV2.loadScalarAsInteger(xmlProfileAnalyzer, "Tref");
            Ne = ProfileChristosV2.loadArrayAsLong(xmlProfileAnalyzer, "Ne");
            NeSd = ProfileChristosV2.loadArrayAsDouble(xmlProfileAnalyzer, "NeSd");
            Nve = ProfileChristosV2.loadArrayAsDouble(xmlProfileAnalyzer, "Nve");
            Te = ProfileChristosV2.loadArrayAsInteger(xmlProfileAnalyzer, "Te");
            reads = ProfileChristosV2.loadArrayAsLong(xmlProfileAnalyzer, "Reads");
            writes = ProfileChristosV2.loadArrayAsLong(xmlProfileAnalyzer, "Writes");
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        xL = new Value[M];
        xU = new Value[M];
        for (int j = 0; j < M / 5; ++j) {
            ProfileChristosV2.xL[5 * j + 0] = new ValInt(1);
            ProfileChristosV2.xU[5 * j + 0] = new ValInt(6);
            ProfileChristosV2.xL[5 * j + 1] = new ValInt(0);
            ProfileChristosV2.xU[5 * j + 1] = new ValInt(6);
            ProfileChristosV2.xL[5 * j + 2] = new ValLong(0L);
            ProfileChristosV2.xU[5 * j + 2] = new ValLong(Ne[j]);
            ProfileChristosV2.xL[5 * j + 3] = new ValInt(0);
            ProfileChristosV2.xU[5 * j + 3] = new ValInt(6);
            ProfileChristosV2.xL[5 * j + 4] = new ValLong(0L);
            ProfileChristosV2.xU[5 * j + 4] = new ValLong(Ne[j]);
        }
    }

    public static int loadScalarAsInteger(Element xmlProfileAnalyzer, String scalarName) {
        int scalar = 0;
        Element xmlNode = (Element)xmlProfileAnalyzer.getElementsByTagName(scalarName).item(0);
        scalar = Integer.valueOf(xmlNode.getAttribute("Value"));
        return scalar;
    }

    public static int[] loadArrayAsInteger(Element xmlProfileAnalyzer, String arrayName) {
        Element xmlNode = (Element)xmlProfileAnalyzer.getElementsByTagName(arrayName).item(0);
        int size = Integer.valueOf(xmlNode.getAttribute("Size"));
        int[] array = new int[size];
        NodeList xmlItemList = xmlNode.getElementsByTagName("Item");
        for (int i = 0; i < size; ++i) {
            int value;
            Element xmlItem = (Element)xmlItemList.item(i);
            int index = Integer.valueOf(xmlItem.getAttribute("Index"));
            array[index] = value = Integer.valueOf(xmlItem.getAttribute("Value")).intValue();
        }
        return array;
    }

    public static long[] loadArrayAsLong(Element xmlProfileAnalyzer, String arrayName) {
        Element xmlNode = (Element)xmlProfileAnalyzer.getElementsByTagName(arrayName).item(0);
        int size = Integer.valueOf(xmlNode.getAttribute("Size"));
        long[] array = new long[size];
        NodeList xmlItemList = xmlNode.getElementsByTagName("Item");
        for (int i = 0; i < size; ++i) {
            long value;
            Element xmlItem = (Element)xmlItemList.item(i);
            int index = Integer.valueOf(xmlItem.getAttribute("Index"));
            array[index] = value = Long.valueOf(xmlItem.getAttribute("Value")).longValue();
        }
        return array;
    }

    public static double[] loadArrayAsDouble(Element xmlProfileAnalyzer, String arrayName) {
        Element xmlNode = (Element)xmlProfileAnalyzer.getElementsByTagName(arrayName).item(0);
        int size = Integer.valueOf(xmlNode.getAttribute("Size"));
        double[] array = new double[size];
        NodeList xmlItemList = xmlNode.getElementsByTagName("Item");
        for (int i = 0; i < size; ++i) {
            double value;
            Element xmlItem = (Element)xmlItemList.item(i);
            int index = Integer.valueOf(xmlItem.getAttribute("Index"));
            array[index] = value = Double.valueOf(xmlItem.getAttribute("Value")).doubleValue();
        }
        return array;
    }

    public ProfileChristosV2() {
    }

    public ProfileChristosV2(Value[] x) {
        this.x = x;
    }

    public ProfileChristosV2(ProfileChristosV2 src) {
        super(src);
    }

    @Override
    public ProfileChristosV2 clone() {
        ProfileChristosV2 clone = new ProfileChristosV2(this);
        return clone;
    }

    @Override
    public void evaluate() {
        for (int i = 0; i < 3; ++i) {
            this.objectiveVector.set(i, 0.0);
        }
        double memoryAccesses = 0.0;
        double memoryUsage = 0.0;
        double energyConsumption = 0.0;
        double sequentialAccesses = 0.0;
        double randomAccesses = 0.0;
        double averageSize = 0.0;
        double readsCounter = 0.0;
        double writesCounter = 0.0;
        int Te0 = 0;
        int Te1 = 0;
        int Te2 = 0;
        for (int i = 0; i < M / 5; ++i) {
            int ddt0 = this.x[5 * i + 0].intValue();
            int ddt1 = this.x[5 * i + 1].intValue();
            int ddt2 = this.x[5 * i + 3].intValue();
            long na1 = this.x[5 * i + 2].longValue();
            long na2 = this.x[5 * i + 4].longValue();
            Te0 = Tref;
            Te1 = Tref;
            Te2 = Te[i];
            if (ddt1 == 0 || na1 == 0L) {
                Te0 = Te[i];
                this.x[5 * i + 1].setValue(0);
                ddt1 = 0;
                this.x[5 * i + 2].setValue(0);
                na1 = 1L;
                this.x[5 * i + 3].setValue(0);
                ddt2 = 0;
            }
            if (ddt2 == 0 || na2 == 0L) {
                Te1 = Te[i];
                this.x[5 * i + 3].setValue(0);
                ddt2 = 0;
                this.x[5 * i + 4].setValue(0);
                na2 = 1L;
            }
            double complexity = this.calculateComplexity(ddt0, ddt1, ddt2, i);
            double na0 = 1.0 * (double)Ne[i] / (1.0 * (double)na1 * (double)na2);
            if (na0 == 0.0) {
                na0 = Math.round(Long.MAX_VALUE / (na1 * na2));
            }
            if (ddt1 == 0) {
                na1 = 0L;
            }
            if (ddt2 == 0) {
                na2 = 0L;
            }
            sequentialAccesses = 0.0;
            randomAccesses = 0.0;
            averageSize = 0.0;
            readsCounter = 0.0;
            writesCounter = 0.0;
            sequentialAccesses += this.calculateSequentialAccesses(ddt0, na0);
            randomAccesses += this.calculateRandomAccesses(ddt0, na0);
            averageSize += this.calculateAverageSize(ddt0, na0, Te0);
            sequentialAccesses += this.calculateSequentialAccesses(ddt1, na0 * (double)na1);
            randomAccesses += this.calculateRandomAccesses(ddt1, na0 * (double)na1);
            averageSize += this.calculateAverageSize(ddt1, na0 * (double)na1, Te1);
            writesCounter = 1.0 * (double)writes[i];
            readsCounter = 1.0 * (double)reads[i];
            memoryAccesses += (sequentialAccesses += this.calculateSequentialAccesses(ddt2, na0 * (double)na1 * (double)na2)) + (randomAccesses += this.calculateRandomAccesses(ddt2, na0 * (double)na1 * (double)na2));
            memoryUsage += (averageSize += this.calculateAverageSize(ddt2, na0 * (double)na1 * (double)na2, Te2));
            energyConsumption += (0.96 - complexity) * (writesCounter + readsCounter) * 1.0E-4 + (0.04 + complexity) * (writesCounter + readsCounter) * 0.01;
        }
        this.objectiveVector.set(0, memoryAccesses);
        this.objectiveVector.set(1, memoryUsage);
        this.objectiveVector.set(2, energyConsumption);
    }

    public static void main(String[] args) throws Exception {
        String outDir = ".";
        if (args.length < 5) {
            System.out.println("Usage:");
            System.out.println("java -jar ProfileChristosV2.jar <XML-PROFILE> <VEGA|SPEA2|NSGA2> <NumTrials:1..Inf> <NumOfIndividuals:1..Inf> <MaxGenerations:1..Inf> <UniformAnalysis:true|false>");
            args = new String[]{"VDrift.1.pro", "VEGA", "1", "200", "5000", "true"};
            outDir = "D:/jlrisco/Trabajo/MisPapers/WorkingPapers/J SYST SOFTWARE/ResultsV2.0";
            return;
        }
        String proPath = outDir + File.separator + args[0];
        String algorithmName = args[1];
        Integer numberOfTrials = Integer.valueOf(args[2]);
        Integer numberOfIndividuals = Integer.valueOf(args[3]);
        Integer maxGenerations = Integer.valueOf(args[4]);
        Boolean uniformAnalysis = false;
        if (args.length > 5) {
            uniformAnalysis = Boolean.valueOf(args[5]);
        }
        ProfileChristosV2.initializeProblem(proPath);
        Moea algorithm = null;
        for (int i = 0; i < numberOfTrials; ++i) {
            BufferedWriter loggerPop = new BufferedWriter(new FileWriter(new File(proPath + "." + algorithmName + "." + i)));
            System.out.println("Iteration number: " + i);
            Population<Chromosome> popIni = new Population<Chromosome>();
            for (int k = 0; k < numberOfIndividuals; ++k) {
                ProfileChristosV2 ind = new ProfileChristosV2();
                popIni.add(ind);
            }
            if (algorithmName.equals("VEGA")) {
                algorithm = new Vega("Vega", popIni, maxGenerations, 0.8, 0.01);
            } else if (algorithmName.equals("SPEA2")) {
                algorithm = new Spea2("Spea2", popIni, maxGenerations, 0.8, 0.01);
            } else if (algorithmName.equals("NSGA2")) {
                algorithm = new Nsga2("Nsga2", popIni, maxGenerations, 0.8, 0.01);
            }
            double start = System.currentTimeMillis();
            while (!algorithm.done()) {
                if (algorithm.getCurrentGeneration() % 100 == 0) {
                    System.out.println("Current generation: " + algorithm.getCurrentGeneration());
                }
                algorithm.step();
            }
            double end = System.currentTimeMillis();
            System.out.println("Time: " + (end - start) / 1000.0);
            System.out.println("done.");
            loggerPop.write(ProfileChristosV2.PopulationToString(algorithm.getPopulation()));
            loggerPop.flush();
            loggerPop.close();
        }
        if (uniformAnalysis.booleanValue()) {
            ProfileChristosV2.saveUniformObjectives(proPath);
        }
    }

    public static double calculateMean(ArrayList<Double> list) {
        double res = 0.0;
        for (Double d : list) {
            res += d.doubleValue();
        }
        return res /= (double)list.size();
    }

    public static double calculateStd(ArrayList<Double> list, double mean) {
        double res = 0.0;
        for (Double d : list) {
            res += Math.pow(d - mean, 2.0);
        }
        res = Math.sqrt(res / (double)list.size());
        return res;
    }

    public static String ParetoFrontToString(Population<Chromosome> pop) {
        StringBuffer buffer = new StringBuffer();
        Population<Chromosome> popTemp = new Population<Chromosome>();
        popTemp.add(pop);
        popTemp.keepNonDominated();
        for (Chromosome chrom : popTemp) {
            buffer.append(chrom.toString() + "\t");
            buffer.append("\n");
        }
        return buffer.toString();
    }

    public static String PopulationToString(Population<Chromosome> pop) {
        StringBuffer buffer = new StringBuffer();
        Population<Chromosome> popTemp = new Population<Chromosome>();
        popTemp.add(pop);
        for (Chromosome chrom : popTemp) {
            buffer.append(chrom.toString() + "\t");
            buffer.append("\n");
        }
        return buffer.toString();
    }

    public static void saveUniformObjectives(String proPath) throws Exception {
        int i;
        StringBuffer buffer = new StringBuffer();
        BufferedWriter out = new BufferedWriter(new FileWriter(new File(proPath + ".out")));
        Value[] xTemp = new Value[M];
        ProfileChristosV2 temp = null;
        for (int d = 1; d < ddts.length; ++d) {
            for (int i2 = 0; i2 < M / 5; ++i2) {
                xTemp[5 * i2 + 0] = new ValInt(d);
                xTemp[5 * i2 + 1] = new ValInt(0);
                xTemp[5 * i2 + 2] = new ValInt(0);
                xTemp[5 * i2 + 3] = new ValInt(0);
                xTemp[5 * i2 + 4] = new ValInt(0);
            }
            temp = new ProfileChristosV2(xTemp);
            temp.evaluate();
            buffer.append(temp.toString() + "\n");
        }
        if (proPath.indexOf("SimBlob") > -1 || proPath.indexOf("Physics") > -1) {
            for (i = 0; i < M / 5; ++i) {
                xTemp[5 * i + 0].setValue(1);
                xTemp[5 * i + 1].setValue(0);
                xTemp[5 * i + 2].setValue(0);
                xTemp[5 * i + 3].setValue(0);
                xTemp[5 * i + 4].setValue(0);
            }
            temp = new ProfileChristosV2(xTemp);
            temp.evaluate();
            buffer.append(temp.toString() + "\n");
        } else if (proPath.indexOf("VDrift") > -1) {
            for (i = 0; i < M / 5; ++i) {
                if (i != 2) {
                    xTemp[5 * i + 0].setValue(1);
                } else {
                    xTemp[5 * i + 0].setValue(4);
                }
                xTemp[5 * i + 1].setValue(0);
                xTemp[5 * i + 2].setValue(0);
                xTemp[5 * i + 3].setValue(0);
                xTemp[5 * i + 4].setValue(0);
            }
            temp = new ProfileChristosV2(xTemp);
            temp.evaluate();
            buffer.append(temp.toString() + "\n");
        }
        out.write(buffer.toString());
        out.flush();
        out.close();
    }

    private double calculateSequentialAccesses(int ddt, double ne) {
        if (ddt == 1) {
            return 9.0 * ne;
        }
        if (ddt == 2) {
            return 10.0 * ne;
        }
        if (ddt == 3) {
            return 7.0 * ne;
        }
        if (ddt == 4) {
            return 7.0 * ne;
        }
        if (ddt == 5) {
            return 10.0 * ne;
        }
        if (ddt == 6) {
            return 10.0 * ne;
        }
        return 0.0;
    }

    private double calculateRandomAccesses(int ddt, double ne) {
        if (ddt == 1) {
            return 2.0;
        }
        if (ddt == 2) {
            return 3.0;
        }
        if (ddt == 3) {
            return 1.0 * ne / 2.0 + 1.0;
        }
        if (ddt == 4) {
            return 1.0 * ne / 4.0 + 1.0;
        }
        if (ddt == 5) {
            return 1.0 * ne / 3.0 + 1.0;
        }
        if (ddt == 6) {
            return 1.0 * ne / 6.0 + 1.0;
        }
        return 0.0;
    }

    private double calculateAverageSize(int ddt, double ne, int te) {
        if (ddt == 1) {
            return 19.0 * (double)Tref + 1.0 * ne * (double)te;
        }
        if (ddt == 2) {
            return 19.0 * (double)Tref + 1.0 * ne * (double)(Tref + te);
        }
        if (ddt == 3) {
            return 19.0 * (double)Tref + 1.0 * ne * (2.0 * (double)Tref + (double)te);
        }
        if (ddt == 4) {
            return 19.0 * (double)Tref + 1.0 * ne * (3.0 * (double)Tref + (double)te);
        }
        if (ddt == 5) {
            return 20.0 * (double)Tref + 1.0 * ne * (2.0 * (double)Tref + (double)te);
        }
        if (ddt == 6) {
            return 20.0 * (double)Tref + 1.0 * ne * (3.0 * (double)Tref + (double)te);
        }
        return 0.0;
    }

    private double calculateComplexity(int ddt0, int ddt1, int ddt2, int varIndex) {
        double complexity = 0.0;
        complexity = ddt0 == 0 ? (complexity += 0.0) : (ddt0 == 1 || ddt0 == 2 ? (complexity += NeSd[varIndex]) : (complexity += 1.0 / NeSd[varIndex]));
        complexity = ddt1 == 0 ? (complexity += 0.0) : (ddt1 == 1 || ddt1 == 2 ? (complexity += NeSd[varIndex]) : (complexity += 1.0 / NeSd[varIndex]));
        complexity = ddt2 == 0 ? (complexity += 0.0) : (ddt2 == 1 || ddt2 == 2 ? (complexity += NeSd[varIndex]) : (complexity += 1.0 / NeSd[varIndex]));
        return complexity /= 1000.0 + NeSd[varIndex];
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer();
        ObjectiveVector objs = this.getObjectiveVector();
        for (Double value : objs) {
            result.append(value + "\t");
        }
        for (int j = 0; j < M / 5; ++j) {
            int ddt0 = this.x[5 * j + 0].intValue();
            int ddt1 = this.x[5 * j + 1].intValue();
            int ddt2 = this.x[5 * j + 3].intValue();
            result.append(ddt0 + "" + ddt1 + "" + ddt2 + "\t");
        }
        return result.toString();
    }

    public String toPrettyFormat(int j) {
        StringBuffer result = new StringBuffer();
        int ddt0 = this.x[5 * j + 0].intValue();
        int ddt1 = this.x[5 * j + 1].intValue();
        int ddt2 = this.x[5 * j + 3].intValue();
        result.append("'" + ddts[ddt0]);
        if (ddt1 != 0) {
            result.append("(" + ddts[ddt1] + "[" + this.x[5 * j + 2].toString() + "]");
        }
        if (ddt2 != 0) {
            result.append("(" + ddts[ddt2] + "[" + this.x[5 * j + 4].toString() + "]");
        }
        if (ddt1 != 0) {
            result.append(")");
        }
        if (ddt2 != 0) {
            result.append(")");
        }
        result.append(" - " + Ne[j] + "'");
        result.append("\t");
        return result.toString();
    }
}

