/*
 * Decompiled with CFR 0.152.
 */
package moea.moga.genome;

import ext.number.Value;
import moea.commons.Individual;

public abstract class Chromosome
extends Individual {
    public abstract Chromosome clone();

    public Chromosome() {
    }

    public Chromosome(Chromosome src) {
        super(src);
    }

    public boolean crossover(double probabilityOfCrossover, Chromosome dad, Chromosome sister, Chromosome brother) {
        if (Math.random() < probabilityOfCrossover) {
            int pos;
            int j;
            for (j = pos = 1 + (int)((double)(Chromosome.getM() - 1) * Math.random()); j < Chromosome.getM(); ++j) {
                sister.x[j] = dad.x[j].clone();
            }
            for (j = pos; j < Chromosome.getM(); ++j) {
                brother.x[j] = this.x[j].clone();
            }
            sister.invalidateScores();
            brother.invalidateScores();
            return true;
        }
        return false;
    }

    public void mutate(double probabilityOfMutation) {
        Value gene;
        int pos;
        int assuredMutated = (int)((double)M * probabilityOfMutation);
        double randomMutated = (double)M * probabilityOfMutation - (double)assuredMutated;
        for (int j = 0; j < assuredMutated; ++j) {
            pos = (int)(Math.random() * (double)M);
            if (this.x[pos].equals(gene = xL[pos].rand(xU[pos]))) continue;
            this.invalidateScores();
            this.x[pos] = gene;
        }
        if (Math.random() < randomMutated && !this.x[pos = (int)(Math.random() * (double)M)].equals(gene = xL[pos].rand(xU[pos]))) {
            this.invalidateScores();
            this.x[pos] = gene;
        }
    }
}

