/*
 * Decompiled with CFR 0.152.
 */
package moea.mopso.algorithms;

import java.util.Collections;
import moea.commons.Population;
import moea.commons.assigner.AssignerSpea2;
import moea.commons.comparator.ComparatorEuclidean;
import moea.mopso.algorithms.MOPSO;
import moea.mopso.society.Particle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SPSO
extends MOPSO {
    protected Population<Particle> pop2 = new Population();
    protected int pop2SizeMax = this.popSizeMax;
    AssignerSpea2<Particle> assigner = new AssignerSpea2((int)Math.sqrt(this.popSizeMax + this.pop2SizeMax));

    public SPSO(String name, Population<Particle> popIni, int maxT) {
        super(name, popIni, maxT);
    }

    @Override
    public void step() {
        this.pop2 = this.getPopulation();
        Collections.sort(this.pop2, ComparatorEuclidean.getInstance());
        this.pop = new Population();
        for (Particle pTemp : this.pop2) {
            this.pop.add(pTemp.clone());
        }
        Particle p = null;
        for (int i = 0; i < this.pop.size(); ++i) {
            p = (Particle)this.pop.get(i);
            p.updatePosition();
            p.updateVelocity();
            p.applyConstraints();
            p.mutate(1.0 / (double)Particle.getM());
            p.updatePBest();
            p.updateGBest((Particle)this.pop2.get(0));
        }
        ++this.t;
    }

    @Override
    public Population<Particle> getPopulation() {
        Population<Particle> pop12 = new Population<Particle>();
        pop12.add(this.pop);
        pop12.add(this.pop2);
        this.assigner.assignFitness(pop12);
        Population<Particle> pop12Reduced = this.assigner.reduceByFitness(pop12);
        if (pop12Reduced.size() < this.pop2SizeMax) {
            this.assigner.expand(pop12Reduced, pop12, this.pop2SizeMax - pop12Reduced.size());
        } else if (pop12Reduced.size() > this.pop2SizeMax) {
            pop12Reduced = this.assigner.reduce(pop12Reduced, this.pop2SizeMax);
        }
        return pop12Reduced;
    }
}

