/*
 * Decompiled with CFR 0.152.
 */
package moea.mopso.society;

import ext.number.ValReal;
import moea.commons.Individual;
import moea.commons.comparator.ComparatorPareto;

public abstract class Particle
extends Individual {
    protected Double w;
    protected Double c1;
    protected Double c2;
    protected ValReal[] v;
    protected Particle pBest;
    protected Particle gBest;

    public abstract Particle clone();

    public Particle(Double w, Double c1, Double c2) {
        this.w = w;
        this.c1 = c1;
        this.c2 = c2;
        this.v = new ValReal[M];
        for (int j = 0; j < M; ++j) {
            this.v[j] = new ValReal(0.0);
        }
        this.pBest = null;
        this.gBest = null;
    }

    public Particle() {
        this(0.55, 1.25, 1.25);
    }

    public Particle(Particle src) {
        super(src);
        this.w = src.w;
        this.c1 = src.c1;
        this.c2 = src.c2;
        this.v = new ValReal[M];
        for (int j = 0; j < M; ++j) {
            this.v[j] = src.v[j].clone();
        }
        this.pBest = src.pBest;
        this.gBest = src.gBest;
    }

    public void mutate(double p) {
        for (int j = 0; j < M; ++j) {
            if (!(Math.random() <= p)) continue;
            this.x[j] = xL[j].rand(xU[j]);
        }
        super.invalidateScores();
    }

    public void applyConstraints() {
        for (int j = 0; j < M; ++j) {
            int comp = this.x[j].compareTo(xL[j]);
            if (comp == -1) {
                this.x[j] = xL[j].clone();
                this.v[j] = this.v[j].opposite();
            }
            if ((comp = this.x[j].compareTo(xU[j])) != 1) continue;
            this.x[j] = xU[j].clone();
            this.v[j] = this.v[j].opposite();
        }
        super.invalidateScores();
    }

    public void updatePosition() {
        for (int j = 0; j < M; ++j) {
            this.x[j] = this.x[j].add(this.v[j]);
        }
        super.invalidateScores();
    }

    public void updateVelocity() {
        for (int j = 0; j < M; ++j) {
            double r1 = Math.random();
            double r2 = Math.random();
            this.v[j] = this.v[j].multiply(this.w);
            if (this.pBest != null) {
                this.v[j] = this.v[j].add(this.pBest.x[j].substract(this.x[j]).multiply(this.c1 * r1));
            }
            if (this.gBest == null) continue;
            this.v[j] = this.v[j].add(this.gBest.x[j].substract(this.x[j]).multiply(this.c2 * r2));
        }
    }

    public void updatePBest() {
        ComparatorPareto comparator = ComparatorPareto.getInstance();
        if (this.pBest == null || comparator.compare(this, this.pBest) == -1) {
            this.pBest = this.clone();
        }
    }

    public void updateGBest(Particle best) {
        this.gBest = best == null ? null : best.clone();
    }

    public void setW(Double w) {
        this.w = w;
    }

    public void setC1(Double c1) {
        this.c1 = c1;
    }

    public void setC2(Double c2) {
        this.c2 = c2;
    }

    public double getW() {
        return this.w;
    }

    public double getC1() {
        return this.c1;
    }

    public double getC2() {
        return this.c2;
    }

    public Particle getPBest() {
        return this.pBest;
    }
}

