/*
 * Decompiled with CFR 0.152.
 */
package Individuals.FitnessPackage;

import Individuals.FitnessPackage.DoubleFitness;
import Individuals.FitnessPackage.Fitness;
import Individuals.GEIndividual;
import Individuals.Individual;
import Util.Random.MersenneTwisterFast;
import java.util.ArrayList;
import java.util.Collections;

public class BasicFitness
implements Fitness {
    public static final double DEFAULT_FITNESS = 1.0E8;
    private static double Min_Double = 0.0;
    private static double Max_Double = 1.0E8;
    private static int Min_Int = 0;
    private static int Max_Int = 100000000;
    private double value;
    private Individual individual;

    public BasicFitness() {
        this.value = 0.0;
    }

    public BasicFitness(double f, Individual i) {
        this.value = f;
        this.individual = i;
    }

    public BasicFitness(Individual i) {
        this.individual = i;
    }

    public int compareTo(Fitness o) {
        double dO = o.getDouble();
        double dT = this.value;
        if (Double.isNaN(dO) || Double.isInfinite(dO)) {
            dO = Max_Double;
        }
        if (Double.isNaN(dT) || Double.isInfinite(dT)) {
            dT = Max_Double;
        }
        if (dT < dO) {
            return -1;
        }
        if (dT > dO) {
            return 1;
        }
        return 0;
    }

    public double getMaxDoubleFitness() {
        return Max_Double;
    }

    public void setMaxDoubleFitness(double d) {
        Max_Double = d;
    }

    public double getMinDoubleFitness() {
        return Min_Double;
    }

    public void setMinDoubleFitness(double d) {
        Min_Double = d;
    }

    public int getMaxIntFitness() {
        return Max_Int;
    }

    public void setMaxIntFitness(int d) {
        Max_Int = d;
    }

    public int getMinIntFitness() {
        return Min_Int;
    }

    public void setMinIntFitness(int d) {
        Min_Int = d;
    }

    public void setDefault() {
        this.value = 1.0E8;
    }

    public double getDefaultFitness() {
        return 1.0E8;
    }

    public double getDouble() {
        return this.value;
    }

    public double getDistance(DoubleFitness f) {
        return this.value - f.getDouble();
    }

    public Individual getIndividual() {
        return this.individual;
    }

    public void setIndividual(Individual i) {
        this.individual = i;
    }

    public void setDouble(double f) {
        if (Double.isNaN(f) || Double.isInfinite(f)) {
            f = Max_Double;
        }
        this.value = f;
    }

    public int getInt() {
        return (int)this.value;
    }

    public void setInt(int f) {
        this.value = f;
    }

    public static void main(String[] args) {
        BasicFitness f = new BasicFitness();
        f.getDouble();
        GEIndividual i = new GEIndividual();
        i.setFitness(f);
        f = (BasicFitness)i.getFitness();
        f.setDouble(10.0);
        System.out.println(f.getDouble());
        MersenneTwisterFast m = new MersenneTwisterFast();
        ArrayList<BasicFitness> list = new ArrayList<BasicFitness>();
        for (int j = 0; j < 100; ++j) {
            BasicFitness fit = new BasicFitness(m.nextDouble(), i);
            list.add(fit);
            System.out.println(fit.getDouble() + ", ");
        }
        System.out.println("Sort Ascending !");
        Collections.sort(list);
        for (BasicFitness aList : list) {
            System.out.println(aList.getDouble() + ", ");
        }
        System.out.println("Sort Descending yeah !");
        Collections.sort(list);
        for (BasicFitness aList : list) {
            System.out.println(aList.getDouble() + ", ");
        }
    }
}

