/*
 * Decompiled with CFR 0.152.
 */
package Individuals.Populations;

import Individuals.AbstractIndividual;
import Individuals.Individual;
import Individuals.Populations.Population;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimplePopulation
implements Population {
    ArrayList<Individual> indies;

    public SimplePopulation() {
        this.indies = new ArrayList();
    }

    public SimplePopulation(int size) {
        this.indies = new ArrayList(size);
    }

    @Override
    public void add(Individual i) {
        this.indies.add(i);
    }

    @Override
    public void sort() {
    }

    @Override
    public Iterator<Individual> iterator() {
        return this.indies.iterator();
    }

    @Override
    public int size() {
        return this.indies.size();
    }

    @Override
    public void addAll(Collection<Individual> immigrants) {
        for (Individual immigrant : immigrants) {
            this.indies.add(immigrant);
        }
    }

    @Override
    public void addAll(Population immigrants) {
        Iterator<Individual> indIt = immigrants.iterator();
        while (indIt.hasNext()) {
            this.indies.add(indIt.next());
        }
    }

    @Override
    public List<Individual> getAll() {
        return this.indies;
    }

    public boolean contains(AbstractIndividual individual) {
        return this.indies.contains(individual);
    }

    public String toString() {
        String s = "";
        Iterator<Individual> iIt = this.indies.iterator();
        DecimalFormat df = new DecimalFormat("#0.00");
        while (iIt.hasNext()) {
            Individual ind = iIt.next();
            String f = df.format(ind.getFitness().getDouble());
            s = s + f + ",";
        }
        return s;
    }

    @Override
    public boolean contains(Individual individual) {
        return this.indies.contains(individual);
    }

    @Override
    public Individual get(int index) {
        return this.indies.get(index);
    }

    @Override
    public void clear() {
        this.indies.clear();
    }

    @Override
    public void remove(Individual ind) {
        this.indies.remove(ind);
    }
}

