/*
 * Decompiled with CFR 0.152.
 */
package Mapper;

import Mapper.Mapper;
import Mapper.Rule;
import Mapper.Symbol;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Grammar
implements Mapper {
    private boolean validGrammar;
    private int startSymbol_index;
    ArrayList<Rule> rules;

    @Override
    public abstract boolean genotype2Phenotype();

    @Override
    public abstract boolean phenotype2Genotype();

    @Override
    public abstract void clear();

    Grammar() {
        this.setValidGrammar(false);
        this.startSymbol_index = 0;
        this.rules = new ArrayList();
    }

    Grammar(Grammar copy) {
        ArrayList<Rule> aLR = new ArrayList<Rule>();
        Iterator<Rule> ruleIt = copy.rules.iterator();
        while (ruleIt.hasNext()) {
            Rule r = new Rule(ruleIt.next());
            aLR.add(r);
        }
        this.rules = aLR;
        this.setValidGrammar(copy.getValidGrammar());
        this.startSymbol_index = copy.startSymbol_index;
    }

    boolean getValidGrammar() {
        return this.validGrammar;
    }

    void setValidGrammar(boolean newValidGrammar) {
        this.validGrammar = newValidGrammar;
    }

    public Symbol getStartSymbol() {
        return this.rules.get(this.startSymbol_index).getLHS();
    }

    boolean setStartSymbol(int index) {
        if (index < this.rules.size()) {
            this.startSymbol_index = index;
            this.genotype2Phenotype();
            return true;
        }
        return false;
    }

    public boolean setStartSymbol(Symbol newStartSymbol) {
        for (Rule rule1 : this.rules) {
            Rule rule = rule1;
            if (!rule.getLHS().equals(newStartSymbol)) continue;
            this.startSymbol_index = this.rules.indexOf(rule);
            this.genotype2Phenotype();
            return true;
        }
        return false;
    }

    public boolean setStartSymbol(String newStartSymbol) {
        for (Rule rule1 : this.rules) {
            Rule rule = rule1;
            if (!rule.getLHS().getSymbolString().equals(newStartSymbol)) continue;
            this.startSymbol_index = this.rules.indexOf(rule);
            this.genotype2Phenotype();
            return true;
        }
        return false;
    }

    public Rule getStartRule() {
        return this.rules.get(this.startSymbol_index);
    }

    public ArrayList<Rule> getRules() {
        return this.rules;
    }

    public void setRules(ArrayList<Rule> newRules) {
        this.rules = newRules;
    }
}

