/*
 * Decompiled with CFR 0.152.
 */
package Operator.Operations;

import Individuals.FitnessPackage.Fitness;
import Individuals.Individual;
import Operator.Operations.Operation;
import java.util.Collections;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EliteReplacementOperation
implements Operation {
    private int eliteSize;

    public EliteReplacementOperation(int size) {
        this.eliteSize = size;
    }

    public EliteReplacementOperation(Properties p) {
        this.setProperties(p);
    }

    @Override
    public void setProperties(Properties p) {
        int value = 0;
        String key = "elite_size";
        this.eliteSize = value = Integer.parseInt(p.getProperty(key, "0"));
    }

    @Override
    public void doOperation(Individual operand) {
    }

    @Override
    public void doOperation(List<Individual> operand) {
        Collections.sort(operand);
        int cnt = operand.size();
        while (cnt > this.eliteSize && cnt > 0) {
            operand.remove(--cnt);
        }
    }

    public void printHelp(Fitness[] fA) {
        String s = "";
        for (Fitness aFA : fA) {
            s = s + aFA.getDouble() + ",";
        }
        System.out.println("sorted elites:" + s);
    }
}

