/*
 * Decompiled with CFR 0.152.
 */
package Operator.Operations;

import Exceptions.BadParameterException;
import Individuals.FitnessPackage.Fitness;
import Individuals.Individual;
import Operator.Operations.Operation;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplacementOperation
implements Operation {
    protected int replacementSize;
    protected Fitness[] fitnessA;

    public ReplacementOperation(int size) {
        this.replacementSize = size;
    }

    public ReplacementOperation(Properties p) {
        this.setProperties(p);
    }

    @Override
    public void setProperties(Properties p) {
        int size;
        double valueD = 1.0;
        String key = "population_size";
        int popSize = Integer.parseInt(p.getProperty(key, "10"));
        key = "replacement_type";
        if (p.getProperty(key) != null) {
            if (p.getProperty(key).equals("steady_state")) {
                valueD = 1.0 / (double)popSize;
            } else if (p.getProperty(key).equals("generational")) {
                valueD = 1.0;
            }
        } else {
            key = "generation_gap";
            try {
                if (p.getProperty(key) != null && ((valueD = Double.parseDouble(p.getProperty(key))) < 0.0 || valueD > 1.0)) {
                    throw new BadParameterException(key);
                }
            }
            catch (Exception e) {
                valueD = 1.0;
                System.out.println(e + " using default: " + valueD);
            }
        }
        this.replacementSize = size = (int)((double)popSize * valueD);
    }

    @Override
    public void doOperation(Individual operand) {
    }

    @Override
    public void doOperation(List<Individual> operand) {
        this.fitnessA = this.rankPopulation(operand);
        this.removeIndividuals(operand, this.replacementSize);
    }

    public void doOperation(List<Individual> operand, int size) {
        this.fitnessA = this.rankPopulation(operand);
        this.removeIndividuals(operand, size);
    }

    private void removeIndividuals(List<Individual> operand, int size) {
        int cnt = 0;
        while (cnt < size) {
            operand.remove(this.fitnessA[this.fitnessA.length - ++cnt].getIndividual());
        }
    }

    private Fitness[] rankPopulation(List<Individual> operand) {
        Object[] fA = new Fitness[operand.size()];
        for (int i = 0; i < fA.length; ++i) {
            fA[i] = operand.get(i).getFitness();
        }
        Arrays.sort(fA);
        return fA;
    }

    public void setReplacementSize(int i) {
        this.replacementSize = i;
    }

    public int getReplacementSize() {
        return this.replacementSize;
    }
}

