/*
 * Decompiled with CFR 0.152.
 */
package com.rie.rieps.engine.fonts;

import com.rie.rieps.engine.fonts.AskForUnknownFontPanel;
import com.rie.rieps.engine.fonts.PSFont;
import com.rie.rieps.exception.RiepsException;
import java.awt.Font;
import java.awt.Frame;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.swing.JDialog;

public class PSFontFinder {
    private static final String dot = "-";
    private Map awtps = new HashMap();
    private boolean echoMapping = false;
    private boolean askForUnkownAWTFont = false;
    private String[] availableDevicePSFont;

    public void setAvailableDeviceFont(String[] deviceFnt) {
        this.availableDevicePSFont = new String[deviceFnt.length];
        System.arraycopy(deviceFnt, 0, this.availableDevicePSFont, 0, deviceFnt.length);
    }

    public void addMappingFile(File f) throws IOException {
        Properties prp = new Properties();
        FileInputStream is = new FileInputStream(f);
        prp.load(is);
        Set<Map.Entry<Object, Object>> es = prp.entrySet();
        for (Map.Entry<Object, Object> e : es) {
            try {
                PSFont psfnt = new PSFont((String)e.getValue());
                this.addAwtPS((String)e.getKey(), psfnt);
            }
            catch (RiepsException ex) {
                System.err.println("Can't create a PSFont from this description : '" + e.getValue() + "'");
                ex.printStackTrace(System.err);
            }
        }
        ((InputStream)is).close();
    }

    private void addAwtPS(String awt, PSFont psfnt) {
        if (this.isEchoMapping()) {
            System.out.println(awt + "=" + psfnt.getPSDesc());
        }
        this.awtps.put(awt, psfnt);
    }

    public PSFont searchPSFont(Font fnt) {
        PSFont psfnt = null;
        String s = fnt.getFamily() + dot + fnt.getStyle() + dot + fnt.getSize2D();
        psfnt = (PSFont)this.getAwtPSMapping().get(s);
        if (psfnt != null) {
            return psfnt;
        }
        s = fnt.getFamily() + dot + fnt.getStyle();
        psfnt = (PSFont)this.getAwtPSMapping().get(s);
        if (psfnt != null) {
            return psfnt.setSize(fnt.getSize2D());
        }
        s = fnt.getFamily();
        psfnt = (PSFont)this.getAwtPSMapping().get(s);
        if (psfnt != null) {
            return psfnt.setSize(fnt.getSize2D());
        }
        if (this.askForUnkownAWTFont()) {
            AWTPSLink link = this.askForUnkown(fnt);
            this.addAwtPS(link.getAWTDesc(), link.getPsfont());
            return this.searchPSFont(fnt);
        }
        return PSFont.DEFAULT.setSize(fnt.getSize2D());
    }

    public boolean askForUnkownAWTFont() {
        return this.askForUnkownAWTFont;
    }

    public void askForUnkownAWTFont(boolean askForUnkownAWTFont) {
        this.askForUnkownAWTFont = askForUnkownAWTFont;
    }

    private AWTPSLink askForUnkown(Font awt) {
        Object psfnt = null;
        JDialog jd = new JDialog((Frame)null, "Link awt/Sytem font with postscript", true);
        AskForUnknownFontPanel jp = new AskForUnknownFontPanel(jd, awt, this.availableDevicePSFont);
        jd.setContentPane(jp);
        jd.pack();
        jd.setLocationRelativeTo(null);
        jd.setDefaultCloseOperation(2);
        jd.setVisible(true);
        AWTPSLink l = null;
        if (jp.isLinked()) {
            l = new AWTPSLink(jp.getPSFont(), jp.getAWTID());
        }
        return l;
    }

    public Map getAwtPSMapping() {
        return new HashMap(this.awtps);
    }

    public static final void main(String[] args) {
        PSFontFinder psff = new PSFontFinder();
        psff.setAvailableDeviceFont(new String[]{"Times-Roman", "Helvetica", "Courier", "Times-Italic", "Times-Bold", "Helvetica-Bold"});
        psff.askForUnkownAWTFont(true);
        psff.setEchoMapping(true);
        psff.searchPSFont(new Font("Dialog", 3, 13));
    }

    public boolean isEchoMapping() {
        return this.echoMapping;
    }

    public void setEchoMapping(boolean echoMapping) {
        this.echoMapping = echoMapping;
    }

    private static class AWTPSLink {
        private PSFont psfont;
        private String awtDesc;

        AWTPSLink(PSFont psfnt, String awtd) {
            this.psfont = psfnt;
            this.awtDesc = awtd;
        }

        public PSFont getPsfont() {
            return this.psfont;
        }

        public String getAWTDesc() {
            return this.awtDesc;
        }
    }
}

