/*
 * Decompiled with CFR 0.152.
 */
package com.rie.rieps.engine.image;

import com.rie.rieps.engine.image.Image;
import com.rie.rieps.engine.image.SmallGrayImage;
import com.rie.rieps.exception.RiepsException;
import java.awt.image.BufferedImage;

public class ImageFactory {
    private static final int SMALL_GRAY_IMG = 0;
    private int type = 0;
    private int sg_convmode = -1;

    private ImageFactory(int type) {
        this.type = type;
    }

    public Image create(BufferedImage bi) throws RiepsException {
        Image img = null;
        switch (this.type) {
            case 0: {
                img = new SmallGrayImage(this.getSg_convmode());
            }
        }
        img.load(bi);
        return img;
    }

    public static ImageFactory createSmallGrayImageFactory(int convert_mode) {
        ImageFactory imgf = new ImageFactory(0);
        imgf.setSg_convmode(convert_mode);
        return imgf;
    }

    private int getSg_convmode() {
        return this.sg_convmode;
    }

    private void setSg_convmode(int sg_convmode) {
        this.sg_convmode = sg_convmode;
    }
}

