/*
 * Decompiled with CFR 0.152.
 */
package com.rie.rieps.engine.image;

import com.rie.rieps.engine.image.Image;
import com.rie.rieps.exception.RiepsException;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;

public class SmallGrayImage
implements Image {
    private static final int maxvalue = 100;
    public static final int CONVERT_MODE_AVERAGE = 0;
    public static final int CONVERT_MODE_CIE_709 = 1;
    public static final int CONVERT_MODE_CIE_601 = 2;
    private StringBuffer psimg = null;
    private float red_coef = 1.0f;
    private float green_coef = 1.0f;
    private float blue_coef = 1.0f;
    private float divide = 3.0f;

    public SmallGrayImage(int convert_mode) {
        if (convert_mode < 0 && convert_mode > 2) {
            convert_mode = 0;
        }
        this.setMode(convert_mode);
    }

    private void setMode(int mode) {
        switch (mode) {
            case 0: {
                this.red_coef = 1.0f;
                this.green_coef = 1.0f;
                this.blue_coef = 1.0f;
                this.divide = 3.0f;
                break;
            }
            case 1: {
                this.red_coef = 0.2125f;
                this.green_coef = 0.7154f;
                this.blue_coef = 0.0721f;
                this.divide = 1.0f;
                break;
            }
            case 2: {
                this.red_coef = 0.299f;
                this.green_coef = 0.587f;
                this.blue_coef = 0.114f;
                this.divide = 1.0f;
            }
        }
    }

    public void load(BufferedImage img) throws RiepsException {
        if (this.psimg != null) {
            throw new RiepsException("The image has already been loaded.");
        }
        this.loadImg(img);
    }

    public StringBuffer getPSImage() throws RiepsException {
        if (this.psimg == null) {
            throw new RiepsException("You have to load the image before getting the postscript.");
        }
        return this.psimg;
    }

    private void loadImg(BufferedImage img) {
        StringBuffer sb = new StringBuffer(1500);
        int width = img.getWidth();
        int height = img.getHeight();
        sb.append(width);
        sb.append(" ");
        sb.append(height);
        sb.append(" 8 [");
        sb.append(width);
        sb.append(" 0  0 ");
        sb.append(height * -1);
        sb.append(" 0 ");
        sb.append(height);
        sb.append("]\n{<\n");
        sb.append(this.convertImg(img, width, height));
        sb.append(">} image");
        this.psimg = sb;
    }

    private StringBuffer convertImg(BufferedImage img, int w, int h) {
        StringBuffer sb = new StringBuffer();
        Raster raster = img.getData();
        int[] pix = new int[4];
        int n = 0;
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                int av = (int)((this.red_coef * (float)(pix = raster.getPixel(x, y, pix))[0] + this.green_coef * (float)pix[1] + this.blue_coef * (float)pix[2]) / this.divide);
                if (av < 16) {
                    sb.append(0);
                }
                sb.append(Integer.toHexString(av));
                if (++n < 100) continue;
                sb.append("\n");
                n = 0;
            }
        }
        return sb;
    }
}

