/*
 * Decompiled with CFR 0.152.
 */
package ext.number;

import ext.number.Value;

public class ValInt
extends Value {
    public static final ValInt MIN_VALUE = new ValInt(Integer.MIN_VALUE);
    public static final ValInt MAX_VALUE = new ValInt(Integer.MAX_VALUE);
    public static final ValInt ZERO = new ValInt(0);

    public ValInt(int value) {
        this.value = value;
    }

    public ValInt(ValInt src) {
        this(src.value.intValue());
    }

    public ValInt add(Value right) {
        return new ValInt(this.value.intValue() + right.value.intValue());
    }

    public ValInt substract(Value right) {
        return new ValInt(this.value.intValue() - right.value.intValue());
    }

    public int compareTo(Value right) {
        if (this.value.intValue() < right.value.intValue()) {
            return -1;
        }
        if (this.value.intValue() > right.value.intValue()) {
            return 1;
        }
        return 0;
    }

    public ValInt rand() {
        return new ValInt(randomGenerator.nextInt());
    }

    public ValInt rand(Value upperBound) {
        return new ValInt(this.value.intValue() + randomGenerator.nextInt(upperBound.value.intValue() - this.value.intValue() + 1));
    }

    public boolean equals(Object right) {
        return right instanceof Value && this.value.intValue() == ((Value)right).value.intValue();
    }

    public ValInt clone() {
        return new ValInt(this);
    }

    public String toString() {
        return "" + this.value;
    }

    public ValInt opposite() {
        return new ValInt(-this.value.intValue());
    }

    public ValInt multiply(Number right) {
        return new ValInt(this.value.intValue() * right.intValue());
    }
}

