/*
 * Decompiled with CFR 0.152.
 */
package ext.number;

import ext.number.Value;

public class ValModInt
extends Value {
    public static Integer MODULUS = Integer.MAX_VALUE;
    public static final ValModInt ZERO = new ValModInt(0);

    public ValModInt(int value) {
        this.value = value % MODULUS;
    }

    public ValModInt(ValModInt src) {
        this(src.value.intValue());
    }

    public ValModInt add(Value right) {
        return new ValModInt(this.value.intValue() + right.value.intValue());
    }

    public ValModInt substract(Value right) {
        return new ValModInt(this.value.intValue() - right.value.intValue());
    }

    public int compareTo(Value right) {
        if (this.value.intValue() < right.value.intValue()) {
            return -1;
        }
        if (this.value.intValue() > right.value.intValue()) {
            return 1;
        }
        return 0;
    }

    public ValModInt rand() {
        return new ValModInt(randomGenerator.nextInt());
    }

    public ValModInt rand(Value upperBound) {
        return new ValModInt(this.value.intValue() + randomGenerator.nextInt(upperBound.value.intValue() - this.value.intValue() + 1));
    }

    public boolean equals(Object right) {
        return right instanceof Value && this.value.intValue() == ((Value)right).value.intValue();
    }

    public ValModInt clone() {
        return new ValModInt(this);
    }

    public String toString() {
        return "" + this.value;
    }

    public static void setModulus(int modulus) throws Exception {
        if (modulus <= 0) {
            throw new Exception("modulus must be greater than zero.");
        }
        MODULUS = modulus;
    }

    public ValModInt opposite() {
        return new ValModInt(-this.value.intValue());
    }

    public ValModInt multiply(Number right) {
        return new ValModInt(this.value.intValue() * right.intValue());
    }
}

