/*
 * Decompiled with CFR 0.152.
 */
package ext.number;

import ext.number.Value;

public class ValModPosInt
extends Value {
    public static Integer MODULUS = Integer.MAX_VALUE;
    public static final ValModPosInt ZERO = new ValModPosInt(0);

    public ValModPosInt(int value) {
        this.value = Math.abs(value) % MODULUS;
    }

    public ValModPosInt(ValModPosInt src) {
        this(src.value.intValue());
    }

    public ValModPosInt add(Value right) {
        return new ValModPosInt(this.value.intValue() + right.value.intValue());
    }

    public ValModPosInt substract(Value right) {
        return new ValModPosInt(this.value.intValue() - right.value.intValue());
    }

    public int compareTo(Value right) {
        if (this.value.intValue() < right.value.intValue()) {
            return -1;
        }
        if (this.value.intValue() > right.value.intValue()) {
            return 1;
        }
        return 0;
    }

    public ValModPosInt rand() {
        return new ValModPosInt(randomGenerator.nextInt());
    }

    public ValModPosInt rand(Value upperBound) {
        return new ValModPosInt(this.value.intValue() + randomGenerator.nextInt(upperBound.value.intValue() - this.value.intValue() + 1));
    }

    public boolean equals(Object right) {
        return right instanceof Value && this.value.intValue() == ((Value)right).value.intValue();
    }

    public ValModPosInt clone() {
        return new ValModPosInt(this);
    }

    public String toString() {
        return "" + this.value;
    }

    public static void setModulus(int modulus) throws Exception {
        if (modulus <= 0) {
            throw new Exception("modulus must be greater than zero.");
        }
        MODULUS = modulus;
    }

    public ValModPosInt opposite() {
        return new ValModPosInt(-this.value.intValue());
    }

    public ValModPosInt multiply(Number right) {
        return new ValModPosInt(this.value.intValue() * right.intValue());
    }
}

