/*
 * Decompiled with CFR 0.152.
 */
package jeco.dmm;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import jeco.dmm.simulator.DMMStructureGF;
import jeco.dmm.simulator.headers.EmptyHeader;
import jeco.dmm.simulator.headers.LeaHeader;
import jeco.dmm.simulator.headers.SizeHeader;
import jeco.dmm.simulator.layers.coalescing.CoalesceHeap;
import jeco.dmm.simulator.layers.coalescing.CoalesceableHeap;
import jeco.dmm.simulator.layers.combining.HeapList;
import jeco.dmm.simulator.layers.freelists.FIFODLBestFitHeap;
import jeco.dmm.simulator.layers.freelists.FIFODLFirstFitHeap;
import jeco.dmm.simulator.layers.freelists.FIFODLFixedListHeap;
import jeco.dmm.simulator.layers.freelists.FIFOSLBestFitHeap;
import jeco.dmm.simulator.layers.freelists.FIFOSLFirstFitHeap;
import jeco.dmm.simulator.layers.freelists.FIFOSLFixedListHeap;
import jeco.dmm.simulator.layers.freelists.LIFODLBestFitHeap;
import jeco.dmm.simulator.layers.freelists.LIFODLFirstFitHeap;
import jeco.dmm.simulator.layers.freelists.LIFODLFixedListHeap;
import jeco.dmm.simulator.layers.freelists.LIFOSLBestFitHeap;
import jeco.dmm.simulator.layers.freelists.LIFOSLFirstFitHeap;
import jeco.dmm.simulator.layers.freelists.LIFOSLFixedListHeap;
import jeco.dmm.simulator.layers.root.FixedHeap;
import jeco.dmm.simulator.layers.root.SbrkHeap;
import jeco.dmm.simulator.layers.simple.SingletonHeap;
import jeco.dmm.simulator.layers.simple.SlopHeap;
import jeco.dmm.simulator.selectors.GtSelector;
import jeco.dmm.simulator.selectors.GteSelector;
import jeco.dmm.simulator.selectors.LtSelector;
import jeco.dmm.simulator.selectors.LteSelector;
import jeco.dmm.simulator.selectors.SizeSelector;
import jeco.dmm.simulator.selectors.TrueSelector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DMMGrammarFilter {
    private String profilePath = "";
    private String grammarPath = "";
    private ArrayList<DMMStructureGF> sizesList;
    private long numOpsNew = 0L;
    private long numOpsDelete = 0L;
    private boolean coalescing = true;
    private long sharedRegions = 0L;
    private boolean useSharedLifes = true;
    private boolean grammarFilterDecidesCoalescing = false;
    private float limitPercentage = 0.0f;
    private long memorySize = 16384L;
    private boolean useSizeSelector = true;
    private boolean useGteSelector = true;
    private boolean useGtSelector = true;
    private boolean useLteSelector = true;
    private boolean useLtSelector = true;
    private boolean useDLLists = true;
    private boolean useSLLists = true;
    private boolean useFIFOLists = true;
    private boolean useLIFOLists = true;
    private boolean useFirstFitPolicy = true;
    private boolean useBestFitPolicy = true;
    private boolean useFixedListPolicy = true;

    public DMMGrammarFilter(long memorySizeInKB, String profile, String grammar) throws Exception {
        this.memorySize = memorySizeInKB;
        this.createPaths(profile, grammar);
    }

    private void createPaths(String profile, String grammar) {
        this.profilePath = profile;
        this.grammarPath = grammar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getInfo() throws Exception {
        long lineNumber = 0L;
        String[] parts = null;
        BufferedReader reader = null;
        boolean firstCoincidence = true;
        try {
            this.sizesList = new ArrayList();
            reader = new BufferedReader(new FileReader(new File(this.profilePath)));
            String line = reader.readLine();
            while (line != null) {
                DMMStructureGF elem;
                ++lineNumber;
                parts = line.split(" ");
                String operation = parts[0];
                long dataSize = Long.valueOf(parts[2]);
                String dataId = parts[1];
                if (operation.equals("new")) {
                    boolean done = false;
                    int i = 0;
                    while (i < this.sizesList.size() && !done) {
                        elem = this.sizesList.get(i);
                        if (dataSize == elem.getSize()) {
                            elem.updateCount();
                            elem.updateAlives();
                            done = true;
                            continue;
                        }
                        if (dataSize < elem.getSize()) {
                            DMMStructureGF e = new DMMStructureGF(dataSize, 1, 1);
                            if (this.useSharedLifes) {
                                for (int j = 0; j < this.sizesList.size(); ++j) {
                                    DMMStructureGF elemTemp = this.sizesList.get(j);
                                    if (elemTemp.getAlives() <= 0L) continue;
                                    if (firstCoincidence) {
                                        this.sharedRegions += 2L;
                                        firstCoincidence = false;
                                        break;
                                    }
                                    ++this.sharedRegions;
                                    break;
                                }
                            }
                            this.sizesList.add(i, e);
                            done = true;
                            continue;
                        }
                        ++i;
                    }
                    if (!done) {
                        DMMStructureGF e = new DMMStructureGF(dataSize, 1, 1);
                        if (this.useSharedLifes) {
                            for (int j = 0; j < this.sizesList.size(); ++j) {
                                DMMStructureGF elemTemp = this.sizesList.get(j);
                                if (elemTemp.getAlives() <= 0L) continue;
                                if (firstCoincidence) {
                                    this.sharedRegions += 2L;
                                    firstCoincidence = false;
                                    break;
                                }
                                ++this.sharedRegions;
                                break;
                            }
                        }
                        this.sizesList.add(e);
                    }
                    ++this.numOpsNew;
                } else if (operation.equals("delete")) {
                    if (this.useSharedLifes) {
                        boolean find = false;
                        for (int i = 0; i < this.sizesList.size() && !find; ++i) {
                            elem = this.sizesList.get(i);
                            if (dataSize != elem.getSize()) continue;
                            elem.decreaseAlives();
                            find = true;
                        }
                        if (!find) {
                            System.err.println("Error in profiling!!!! The data " + dataId + "is never created");
                            throw new Exception();
                        }
                    }
                    ++this.numOpsDelete;
                } else if (!operation.equals("write") && !operation.equals("read")) {
                    System.err.println("Error in profiling!!! The operation in the line " + lineNumber + " is not new, delete, read or write");
                    throw new Exception();
                }
                line = reader.readLine();
            }
            if (this.grammarFilterDecidesCoalescing && this.sharedRegions == 0L) {
                this.coalescing = false;
            }
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
            throw new Exception();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
                throw new Exception();
            }
        }
    }

    public void createGrammar() throws Exception {
        BufferedWriter writer = null;
        try {
            boolean first;
            writer = new BufferedWriter(new FileWriter(this.grammarPath));
            writer.write("<GlobalHeap> ::= <SingletonHeap>\n");
            writer.write("<SingletonHeap> ::= ");
            if (this.coalescing) {
                writer.write(SingletonHeap.class.getName() + "(<CoalesceHeap>)|");
            }
            writer.write(SingletonHeap.class.getName() + "(<HeapList>)\n");
            writer.newLine();
            String sep = "";
            writer.write("<HeapList> ::=");
            if (this.useBestFitPolicy || this.useFirstFitPolicy) {
                writer.write(sep + HeapList.class.getName() + "(<Heap>,<Selectors>,<Tail_Size>)");
                sep = "|";
            }
            if (this.useSizeSelector && this.useFixedListPolicy) {
                writer.write(sep + HeapList.class.getName() + "(<Heap_Size>,<Selectors_Size>,<Tail_Size>)");
                sep = "|";
            }
            writer.write(sep + HeapList.class.getName() + "(<Heap>,<True_Selectors>,<Tail_True>)\n");
            writer.newLine();
            String heap = "<Heap> ::= ";
            String heapSize = "<Heap_Size> ::= ";
            String lists = "";
            String separator = "";
            String separatorSize = "";
            if (this.useFIFOLists) {
                if (this.useDLLists) {
                    if (this.useFirstFitPolicy) {
                        heap = heap + separator + "<FIFODLFirstFitHeap>";
                        heapSize = heapSize + separatorSize + "<FIFODLFirstFitHeap>";
                        separator = "|";
                        separatorSize = "|";
                        lists = lists + "<FIFODLFirstFitHeap> ::= " + FIFODLFirstFitHeap.class.getName() + "(<SizeHeader>)\n";
                    }
                    if (this.useFixedListPolicy && this.useSizeSelector) {
                        heapSize = heapSize + separatorSize + "<FIFODLFixedListHeap>";
                        separatorSize = "|";
                        lists = lists + "<FIFODLFixedListHeap> ::= " + FIFODLFixedListHeap.class.getName() + "(<SizeHeader>)\n";
                    }
                    if (this.useBestFitPolicy) {
                        heap = heap + separator + "<FIFODLBestFitHeap>";
                        heapSize = heapSize + separatorSize + "<FIFODLBestFitHeap>";
                        separator = "|";
                        separatorSize = "|";
                        lists = lists + "<FIFODLBestFitHeap> ::= " + FIFODLBestFitHeap.class.getName() + "(<SizeHeader>)\n";
                    }
                }
                if (this.useSLLists) {
                    if (this.useFirstFitPolicy) {
                        heap = heap + separator + "<FIFOSLFirstFitHeap>";
                        heapSize = heapSize + separatorSize + "<FIFOSLFirstFitHeap>";
                        separator = "|";
                        lists = lists + "<FIFOSLFirstFitHeap> ::= " + FIFOSLFirstFitHeap.class.getName() + "(<SizeHeader>)\n";
                        separatorSize = "|";
                    }
                    if (this.useFixedListPolicy && this.useSizeSelector) {
                        heapSize = heapSize + separatorSize + "<FIFOSLFixedListHeap>";
                        separatorSize = "|";
                        lists = lists + "<FIFOSLFixedListHeap> ::= " + FIFOSLFixedListHeap.class.getName() + "(<SizeHeader>)\n";
                    }
                    if (this.useBestFitPolicy) {
                        heap = heap + separator + "<FIFOSLBestFitHeap>";
                        heapSize = heapSize + separatorSize + "<FIFOSLBestFitHeap>";
                        separator = "|";
                        separatorSize = "|";
                        lists = lists + "<FIFOSLBestFitHeap> ::= " + FIFOSLBestFitHeap.class.getName() + "(<SizeHeader>)\n";
                    }
                }
            }
            if (this.useLIFOLists) {
                if (this.useDLLists) {
                    if (this.useFirstFitPolicy) {
                        heap = heap + separator + "<LIFODLFirstFitHeap>";
                        heapSize = heapSize + separatorSize + "<LIFODLFirstFitHeap>";
                        separator = "|";
                        separatorSize = "|";
                        lists = lists + "<LIFODLFirstFitHeap> ::= " + LIFODLFirstFitHeap.class.getName() + "(<SizeHeader>)\n";
                    }
                    if (this.useFixedListPolicy && this.useSizeSelector) {
                        heapSize = heapSize + separatorSize + "<LIFODLFixedListHeap>";
                        separatorSize = "|";
                        lists = lists + "<LIFODLFixedListHeap> ::= " + LIFODLFixedListHeap.class.getName() + "(<SizeHeader>)\n";
                    }
                    if (this.useBestFitPolicy) {
                        heap = heap + separator + "<LIFODLBestFitHeap>";
                        heapSize = heapSize + separatorSize + "<LIFODLBestFitHeap>";
                        separator = "|";
                        separatorSize = "|";
                        lists = lists + "<LIFODLBestFitHeap> ::= " + LIFODLBestFitHeap.class.getName() + "(<SizeHeader>)\n";
                    }
                }
                if (this.useSLLists) {
                    if (this.useFirstFitPolicy) {
                        heap = heap + separator + "<LIFOSLFirstFitHeap>";
                        heapSize = heapSize + separatorSize + "<LIFOSLFirstFitHeap>";
                        separator = "|";
                        separatorSize = "|";
                        lists = lists + "<LIFOSLFirstFitHeap> ::= " + LIFOSLFirstFitHeap.class.getName() + "(<SizeHeader>)\n";
                    }
                    if (this.useFixedListPolicy && this.useSizeSelector) {
                        heapSize = heapSize + separatorSize + "<LIFOSLFixedListHeap>";
                        separatorSize = "|";
                        lists = lists + "<LIFOSLFixedListHeap> ::= " + LIFOSLFixedListHeap.class.getName() + "(<SizeHeader>)\n";
                    }
                    if (this.useBestFitPolicy) {
                        heap = heap + separator + "<LIFOSLBestFitHeap>";
                        heapSize = heapSize + separatorSize + "<LIFOSLBestFitHeap>";
                        separator = "|";
                        separatorSize = "|";
                        lists = lists + "<LIFOSLBestFitHeap> ::= " + LIFOSLBestFitHeap.class.getName() + "(<SizeHeader>)\n";
                    }
                }
            }
            if (this.useBestFitPolicy || this.useFirstFitPolicy) {
                writer.write(heap);
                writer.newLine();
            }
            if (this.useSizeSelector && this.useFixedListPolicy) {
                writer.write(heapSize);
                writer.newLine();
            }
            writer.write(lists);
            writer.newLine();
            writer.write("<Tail_Size> ::= <HeapList>");
            if (this.coalescing) {
                writer.write("|<CoalesceHeap>\n");
            } else {
                writer.newLine();
            }
            writer.write("<Tail_True> ::= <FixedHeap>");
            if (this.coalescing) {
                writer.write("|<CoalesceHeap>\n");
                writer.newLine();
                writer.write("<CoalesceHeap> ::= " + CoalesceHeap.class.getName() + "(<HeapList_Coalesce>,<MinSize>,<MaxSize>)\n");
                first = true;
                String sizesCoalescing = "";
                for (int i = 0; i < this.sizesList.size(); ++i) {
                    long size = this.sizesList.get(i).getSize();
                    if (first) {
                        sizesCoalescing = Long.toString(size);
                        first = false;
                        continue;
                    }
                    sizesCoalescing = sizesCoalescing + "|" + Long.toString(size);
                }
                writer.write("<MinSize> ::= " + sizesCoalescing);
                writer.newLine();
                writer.write("<MaxSize> ::= " + sizesCoalescing);
                writer.newLine();
                sep = "";
                writer.write("<HeapList_Coalesce> ::=");
                if (this.useBestFitPolicy || this.useFirstFitPolicy) {
                    writer.write(sep + HeapList.class.getName() + "(<Heap_Coalesce>,<Selectors>,<Tail_Coalesce_Size>)");
                    sep = "|";
                }
                if (this.useSizeSelector && this.useFixedListPolicy) {
                    writer.write(sep + HeapList.class.getName() + "(<Heap_Coalesce_Size>,<Selectors_Size>,<Tail_Coalesce_Size>)");
                    sep = "|";
                }
                writer.write(sep + HeapList.class.getName() + "(<Heap_Coalesce>,<True_Selectors>,<Tail_Coalesce_True>)\n");
                writer.newLine();
                heap = "<Heap_Coalesce> ::= ";
                heapSize = "<Heap_Coalesce_Size> ::= ";
                lists = "";
                separator = "";
                separatorSize = "";
                if (this.useFIFOLists) {
                    if (this.useDLLists) {
                        if (this.useFirstFitPolicy) {
                            heap = heap + separator + "<FIFODLFirstFitHeap_Coalesce>";
                            heapSize = heapSize + separatorSize + "<FIFODLFirstFitHeap_Coalesce>";
                            separator = "|";
                            separatorSize = "|";
                            lists = lists + "<FIFODLFirstFitHeap_Coalesce> ::= " + FIFODLFirstFitHeap.class.getName() + "(<LeaHeader>)\n";
                        }
                        if (this.useFixedListPolicy && this.useSizeSelector) {
                            heapSize = heapSize + separatorSize + "<FIFODLFixedListHeap_Coalesce>";
                            separatorSize = "|";
                            lists = lists + "<FIFODLFixedListHeap_Coalesce> ::= " + FIFODLFixedListHeap.class.getName() + "(<LeaHeader>)\n";
                        }
                        if (this.useBestFitPolicy) {
                            heap = heap + separator + "<FIFODLBestFitHeap_Coalesce>";
                            heapSize = heapSize + separatorSize + "<FIFODLBestFitHeap_Coalesce>";
                            separator = "|";
                            separatorSize = "|";
                            lists = lists + "<FIFODLBestFitHeap_Coalesce> ::= " + FIFODLBestFitHeap.class.getName() + "(<LeaHeader>)\n";
                        }
                    }
                    if (this.useSLLists) {
                        if (this.useFirstFitPolicy) {
                            heap = heap + separator + "<FIFOSLFirstFitHeap_Coalesce>";
                            heapSize = heapSize + separatorSize + "<FIFOSLFirstFitHeap_Coalesce>";
                            separator = "|";
                            lists = lists + "<FIFOSLFirstFitHeap_Coalesce> ::= " + FIFOSLFirstFitHeap.class.getName() + "(<LeaHeader>)\n";
                            separatorSize = "|";
                        }
                        if (this.useFixedListPolicy && this.useSizeSelector) {
                            heapSize = heapSize + separatorSize + "<FIFOSLFixedListHeap_Coalesce>";
                            separatorSize = "|";
                            lists = lists + "<FIFOSLFixedListHeap_Coalesce> ::= " + FIFOSLFixedListHeap.class.getName() + "(<LeaHeader>)\n";
                        }
                        if (this.useBestFitPolicy) {
                            heap = heap + separator + "<FIFOSLBestFitHeap_Coalesce>";
                            heapSize = heapSize + separatorSize + "<FIFOSLBestFitHeap_Coalesce>";
                            separator = "|";
                            separatorSize = "|";
                            lists = lists + "<FIFOSLBestFitHeap_Coalesce> ::= " + FIFOSLBestFitHeap.class.getName() + "(<LeaHeader>)\n";
                        }
                    }
                }
                if (this.useLIFOLists) {
                    if (this.useDLLists) {
                        if (this.useFirstFitPolicy) {
                            heap = heap + separator + "<LIFODLFirstFitHeap_Coalesce>";
                            heapSize = heapSize + separatorSize + "<LIFODLFirstFitHeap_Coalesce>";
                            separator = "|";
                            separatorSize = "|";
                            lists = lists + "<LIFODLFirstFitHeap_Coalesce> ::= " + LIFODLFirstFitHeap.class.getName() + "(<LeaHeader>)\n";
                        }
                        if (this.useFixedListPolicy && this.useSizeSelector) {
                            heapSize = heapSize + separatorSize + "<LIFODLFixedListHeap_Coalesce>";
                            separatorSize = "|";
                            lists = lists + "<LIFODLFixedListHeap_Coalesce> ::= " + LIFODLFixedListHeap.class.getName() + "(<LeaHeader>)\n";
                        }
                        if (this.useBestFitPolicy) {
                            heap = heap + separator + "<LIFODLBestFitHeap_Coalesce>";
                            heapSize = heapSize + separatorSize + "<LIFODLBestFitHeap_Coalesce>";
                            separator = "|";
                            separatorSize = "|";
                            lists = lists + "<LIFODLBestFitHeap_Coalesce> ::= " + LIFODLBestFitHeap.class.getName() + "(<LeaHeader>)\n";
                        }
                    }
                    if (this.useSLLists) {
                        if (this.useFirstFitPolicy) {
                            heap = heap + separator + "<LIFOSLFirstFitHeap_Coalesce>";
                            heapSize = heapSize + separatorSize + "<LIFOSLFirstFitHeap_Coalesce>";
                            separator = "|";
                            separatorSize = "|";
                            lists = lists + "<LIFOSLFirstFitHeap_Coalesce> ::= " + LIFOSLFirstFitHeap.class.getName() + "(<LeaHeader>)\n";
                        }
                        if (this.useFixedListPolicy && this.useSizeSelector) {
                            heapSize = heapSize + separatorSize + "<LIFOSLFixedListHeap_Coalesce>";
                            separatorSize = "|";
                            lists = lists + "<LIFOSLFixedListHeap_Coalesce> ::= " + LIFOSLFixedListHeap.class.getName() + "(<LeaHeader>)\n";
                        }
                        if (this.useBestFitPolicy) {
                            heap = heap + separator + "<LIFOSLBestFitHeap_Coalesce>";
                            heapSize = heapSize + separatorSize + "<LIFOSLBestFitHeap_Coalesce>";
                            separator = "|";
                            separatorSize = "|";
                            lists = lists + "<LIFOSLBestFitHeap_Coalesce> ::= " + LIFOSLBestFitHeap.class.getName() + "(<LeaHeader>)\n";
                        }
                    }
                }
                if (this.useBestFitPolicy || this.useFirstFitPolicy) {
                    writer.write(heap);
                    writer.newLine();
                }
                if (this.useSizeSelector && this.useFixedListPolicy) {
                    writer.write(heapSize);
                    writer.newLine();
                }
                writer.write(lists);
                writer.newLine();
                writer.write("<Tail_Coalesce_Size> ::= <HeapList_Coalesce>\n");
                writer.write("<Tail_Coalesce_True> ::= " + CoalesceableHeap.class.getName() + "(<SlopHeap>)\n");
            } else {
                writer.newLine();
            }
            writer.newLine();
            writer.write("<True_Selectors> ::= <True_Selector>, <True_Selector>\n");
            writer.write("<True_Selector> ::=  " + TrueSelector.class.getName() + "\n");
            writer.newLine();
            if (this.useSizeSelector && this.useFixedListPolicy) {
                writer.write("<Selectors_Size> ::= <Size_Selectors>\n\n");
            }
            if (this.useBestFitPolicy || this.useFirstFitPolicy) {
                first = true;
                writer.write("<Selectors> ::= ");
                if (this.useSizeSelector && !this.useFixedListPolicy && first) {
                    writer.write("<Size_Selectors>");
                    first = false;
                }
                if (this.useLtSelector) {
                    if (first) {
                        writer.write("<Lt_Selectors>");
                        first = false;
                    } else {
                        writer.write("|<Lt_Selectors>");
                    }
                }
                if (this.useLteSelector) {
                    if (first) {
                        writer.write("<Lte_Selectors>");
                        first = false;
                    } else {
                        writer.write("|<Lte_Selectors>");
                    }
                }
                if (this.useGtSelector) {
                    if (first) {
                        writer.write("<Gt_Selectors>");
                        first = false;
                    } else {
                        writer.write("|<Gt_Selectors>");
                    }
                }
                if (this.useGteSelector) {
                    if (first) {
                        writer.write("<Gte_Selectors>");
                        first = false;
                    } else {
                        writer.write("|<Gte_Selectors>");
                    }
                }
                writer.newLine();
            }
            String sizeSelectors = "<Size_Selectors> ::= ";
            String ltSelectors = "<Lt_Selectors> ::= ";
            String lteSelectors = "<Lte_Selectors> ::= ";
            String gtSelectors = "<Gt_Selectors> ::= ";
            String gteSelectors = "<Gte_Selectors> ::= ";
            boolean somethingwrited = false;
            for (int i = 0; i < this.sizesList.size(); ++i) {
                long size = this.sizesList.get(i).getSize();
                long elementsOfSize = this.sizesList.get(i).getCount();
                float percentage = elementsOfSize / this.numOpsNew;
                if (!(percentage >= this.limitPercentage)) continue;
                if (!somethingwrited) {
                    sizeSelectors = sizeSelectors + "<SizeSelector_" + size + ">,<SizeSelector_" + size + ">";
                    ltSelectors = ltSelectors + "<LtSelector_" + size + ">,<LtSelector_" + size + ">";
                    lteSelectors = lteSelectors + "<LteSelector_" + size + ">,<LteSelector_" + size + ">";
                    gtSelectors = gtSelectors + "<GtSelector_" + size + ">,<GtSelector_" + size + ">";
                    gteSelectors = gteSelectors + "<GteSelector_" + size + ">,<GteSelector_" + size + ">";
                    somethingwrited = true;
                    continue;
                }
                sizeSelectors = sizeSelectors + " | <SizeSelector_" + size + ">,<SizeSelector_" + size + ">";
                ltSelectors = ltSelectors + " | <LtSelector_" + size + ">,<LtSelector_" + size + ">";
                lteSelectors = lteSelectors + " | <LteSelector_" + size + ">,<LteSelector_" + size + ">";
                gtSelectors = gtSelectors + " | <GtSelector_" + size + ">,<GtSelector_" + size + ">";
                gteSelectors = gteSelectors + " | <GteSelector_" + size + ">,<GteSelector_" + size + ">";
            }
            if (this.useBestFitPolicy || this.useFirstFitPolicy || this.useSizeSelector && this.useFixedListPolicy) {
                writer.write(sizeSelectors + "\n");
            }
            if (this.useBestFitPolicy || this.useFirstFitPolicy) {
                if (this.useLtSelector) {
                    writer.write(ltSelectors + "\n");
                }
                if (this.useLteSelector) {
                    writer.write(lteSelectors + "\n");
                }
                if (this.useGtSelector) {
                    writer.write(gtSelectors + "\n");
                }
                if (this.useGteSelector) {
                    writer.write(gteSelectors + "\n");
                }
                writer.newLine();
            }
            sizeSelectors = "";
            ltSelectors = "";
            lteSelectors = "";
            gtSelectors = "";
            gteSelectors = "";
            String sizes2real = "";
            for (int i = 0; i < this.sizesList.size(); ++i) {
                long size = this.sizesList.get(i).getSize();
                long elementsOfSize = this.sizesList.get(i).getCount();
                float percentage = elementsOfSize / this.numOpsNew;
                if (!(percentage >= this.limitPercentage)) continue;
                sizeSelectors = sizeSelectors + "<SizeSelector_" + size + "> ::= " + SizeSelector.class.getName() + "(<Size_" + size + ">)\n";
                ltSelectors = ltSelectors + "<LtSelector_" + size + "> ::= " + LtSelector.class.getName() + "(<Size_" + size + ">)\n";
                lteSelectors = lteSelectors + "<LteSelector_" + size + "> ::= " + LteSelector.class.getName() + "(<Size_" + size + ">)\n";
                gtSelectors = gtSelectors + "<GtSelector_" + size + "> ::= " + GtSelector.class.getName() + "(<Size_" + size + ">)\n";
                gteSelectors = gteSelectors + "<GteSelector_" + size + "> ::= " + GteSelector.class.getName() + "(<Size_" + size + ">)\n";
                sizes2real = sizes2real + "<Size_" + size + "> ::= " + size + "\n";
            }
            if (this.useBestFitPolicy || this.useFirstFitPolicy || this.useSizeSelector && this.useFixedListPolicy) {
                writer.write(sizeSelectors + "\n");
            }
            if (this.useBestFitPolicy || this.useFirstFitPolicy) {
                if (this.useLtSelector) {
                    writer.write(ltSelectors + "\n");
                }
                if (this.useLteSelector) {
                    writer.write(lteSelectors + "\n");
                }
                if (this.useGtSelector) {
                    writer.write(gtSelectors + "\n");
                }
                if (this.useGteSelector) {
                    writer.write(gteSelectors + "\n");
                }
            }
            writer.write(sizes2real + "\n");
            writer.write("<EmptyHeader> ::= " + EmptyHeader.class.getName() + "\n");
            writer.write("<SizeHeader> ::= " + SizeHeader.class.getName() + "\n");
            if (this.coalescing) {
                writer.write("<LeaHeader> ::= " + LeaHeader.class.getName() + "\n");
            }
            writer.newLine();
            if (this.coalescing) {
                writer.write("<SlopHeap> ::= " + SlopHeap.class.getName() + "(<FixedHeap_Coalesce>, <LeaHeader>)\n");
                writer.write("<FixedHeap_Coalesce> ::= " + FixedHeap.class.getName() + "(<SbrkHeap>,<MemorySizeInKB>,<EmptyHeader>)\n");
            }
            writer.write("<FixedHeap> ::= " + FixedHeap.class.getName() + "(<SbrkHeap>,<MemorySizeInKB>,<SizeHeader>)\n");
            writer.write("<SbrkHeap> ::= " + SbrkHeap.class.getName() + "(<EmptyHeader>)\n");
            writer.write("<MemorySizeInKB> ::= " + this.memorySize + "\n");
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
            throw new Exception();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new Exception();
        }
        finally {
            try {
                if (writer != null) {
                    writer.flush();
                    writer.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
                throw new Exception();
            }
        }
    }

    public ArrayList<DMMStructureGF> getSizesList() {
        return this.sizesList;
    }

    public void setSizesList(ArrayList<DMMStructureGF> sizesList) {
        this.sizesList = sizesList;
    }
}

