/*
 * Decompiled with CFR 0.152.
 */
package jeco.dmm.reliableDMM;

import jeco.dmm.reliableDMM.MemoryBank;

public class LRU {
    protected MemoryBank head = null;
    protected MemoryBank tail = null;
    protected long size = 0L;

    public void insert(MemoryBank memBank) {
        if (this.head == null && this.tail == null) {
            this.head = memBank;
            this.tail = memBank;
            this.head.setNext(null);
            this.head.setPrev(null);
            this.tail.setNext(null);
            this.tail.setPrev(null);
        } else {
            memBank.setNext(this.head);
            this.head.setPrev(memBank);
            this.head = memBank;
            this.head.setPrev(null);
        }
        ++this.size;
    }

    public MemoryBank getLRUBank() {
        MemoryBank lruBank = this.head;
        this.head = this.head.getNext();
        this.head.setPrev(null);
        lruBank.setPrev(this.tail);
        this.tail.setNext(lruBank);
        this.tail = lruBank;
        this.tail.setNext(null);
        return lruBank;
    }

    public boolean update(MemoryBank memBank) {
        int bankId = memBank.getNumOfBank();
        for (MemoryBank currentBank = this.tail; currentBank != null; currentBank = currentBank.getPrev()) {
            if (bankId != currentBank.getNumOfBank()) continue;
            MemoryBank prev = currentBank.getPrev();
            MemoryBank next = currentBank.getNext();
            if (currentBank == this.tail) {
                return true;
            }
            if (currentBank == this.head) {
                this.head = this.head.getNext();
                this.head.setPrev(null);
                this.tail.setNext(currentBank);
                currentBank.setPrev(this.tail);
                this.tail = this.tail.getNext();
                this.tail.setNext(null);
                return true;
            }
            if (prev != null) {
                prev.setNext(next);
            }
            if (next != null) {
                next.setPrev(prev);
            }
            currentBank.setPrev(this.tail);
            this.tail.setNext(currentBank);
            this.tail = currentBank;
            this.tail.setNext(null);
            return true;
        }
        return false;
    }

    public MemoryBank getHead() {
        return this.head;
    }
}

