/*
 * Decompiled with CFR 0.152.
 */
package jeco.dmm.reliableDMM;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import jeco.dmm.reliableDMM.LRU;
import jeco.dmm.reliableDMM.MemoryBank;
import jeco.dmm.reliableDMM.ReliableDMMData;

public class SplitProfile {
    protected int numBanks;
    protected String originalProfilePath;
    protected String finalPath;
    protected LRU lruList;
    protected long limit;
    protected boolean logReadsAndWrites;

    public SplitProfile(int numBanks, String originalProfilePath, String finalPath, long limit, int logReadsAndWrites) throws Exception {
        this.numBanks = numBanks;
        this.originalProfilePath = originalProfilePath;
        this.finalPath = finalPath;
        this.limit = limit;
        this.logReadsAndWrites = logReadsAndWrites == 1;
        this.lruList = new LRU();
        for (int i = 0; i < numBanks; ++i) {
            MemoryBank memBank = new MemoryBank(i, finalPath);
            this.lruList.insert(memBank);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() throws Exception {
        int i;
        long lineNumber = 0L;
        String[] parts = null;
        double time = 0.0;
        String operation = null;
        String dataId = null;
        String size = null;
        String logLine = null;
        int consecutiveAccesses = 0;
        int maxConsecutiveAccesses = 0;
        int activeBank = 0;
        int numExceed = 0;
        BufferedReader reader = new BufferedReader(new FileReader(new File(this.originalProfilePath)));
        ArrayList<ReliableDMMData> activeObjects = new ArrayList<ReliableDMMData>();
        String line = reader.readLine();
        while (line != null) {
            int bankId;
            ++lineNumber;
            parts = line.split(" ");
            if (parts.length == 3) {
                time = lineNumber;
                operation = parts[0];
                dataId = parts[1];
                size = parts[2];
            } else {
                if (parts.length != 4) throw new Exception("Bad format in the profile, line number " + lineNumber + ": " + line);
                time = Double.valueOf(parts[0]);
                operation = parts[1];
                dataId = parts[2];
                size = parts[3];
            }
            logLine = time + " " + operation + " " + dataId + " " + size;
            if (operation.equals("new")) {
                MemoryBank memBank = this.lruList.getLRUBank();
                ReliableDMMData data = new ReliableDMMData(memBank, dataId);
                activeObjects.add(data);
                memBank.writeFile(logLine);
                int bankId2 = memBank.getNumOfBank();
                if (bankId2 != activeBank) {
                    memBank.addAccess(consecutiveAccesses);
                    consecutiveAccesses = 1;
                    activeBank = bankId2;
                } else {
                    ++consecutiveAccesses;
                }
            } else if (operation.equals("delete")) {
                boolean found = false;
                ReliableDMMData data = null;
                for (int i2 = 0; !found && i2 < activeObjects.size(); ++i2) {
                    data = (ReliableDMMData)activeObjects.get(i2);
                    if (!data.getId().equals(dataId)) continue;
                    activeObjects.remove(i2);
                    this.lruList.update(data.getBank());
                    found = true;
                }
                if (!found) throw new Exception("Unexpected error. Reading Profile for SplitProfile. Delete");
                data.getBank().writeFile(logLine);
                bankId = data.getBank().getNumOfBank();
                if (bankId != activeBank) {
                    data.getBank().addAccess(consecutiveAccesses);
                    consecutiveAccesses = 1;
                    activeBank = bankId;
                } else {
                    ++consecutiveAccesses;
                }
            } else {
                boolean found = false;
                ReliableDMMData data = null;
                for (int i3 = 0; !found && i3 < activeObjects.size(); ++i3) {
                    data = (ReliableDMMData)activeObjects.get(i3);
                    if (!data.getId().equals(dataId)) continue;
                    this.lruList.update(data.getBank());
                    found = true;
                }
                if (!found) throw new Exception("Unexpected error. Reading Profile for SplitProfile. Read or write Operation");
                if (this.logReadsAndWrites) {
                    data.getBank().writeFile(logLine);
                }
                if ((bankId = data.getBank().getNumOfBank()) != activeBank) {
                    data.getBank().addAccess(consecutiveAccesses);
                    consecutiveAccesses = 1;
                    activeBank = bankId;
                } else {
                    ++consecutiveAccesses;
                }
            }
            line = reader.readLine();
        }
        reader.close();
        String[] aux = this.originalProfilePath.split("\\.", 2);
        String tempPath = aux[0] + this.numBanks + "BanksReliable.Accesses";
        BufferedWriter writerAccesses = new BufferedWriter(new FileWriter(new File(tempPath)));
        writerAccesses.write("CONCURRENT ACCESSES TO EACH REGION\n");
        for (MemoryBank currentBank = this.lruList.getHead(); currentBank != null; currentBank = currentBank.getNext()) {
            ArrayList<Integer> temp = currentBank.getAccessesList();
            writerAccesses.write("Region " + currentBank.getNumOfBank() + ": ");
            for (i = 0; i < temp.size(); ++i) {
                int auxInt = temp.get(i);
                if (auxInt > maxConsecutiveAccesses) {
                    maxConsecutiveAccesses = auxInt;
                }
                if ((long)auxInt > this.limit) {
                    ++numExceed;
                }
                writerAccesses.write(auxInt + " ");
            }
            writerAccesses.write("\n");
            currentBank.closeFile();
        }
        writerAccesses.write("\nINFO\n----\n");
        writerAccesses.write("Number of regions exceeding " + this.limit + " accesses (ERRORS): " + numExceed + "\n");
        writerAccesses.write("Max number of consecutive accesses: " + maxConsecutiveAccesses + "\n");
        writerAccesses.flush();
        writerAccesses.close();
        MemoryBank iter = this.lruList.head;
        i = 0;
        while ((long)i < this.lruList.size) {
            iter.closeFile();
            iter = iter.next;
            ++i;
        }
    }

    public static void main(String[] args) {
        if (args.length != 5) {
            System.out.println("Usage: java -jar SplitProfile.jar <PathToOriginalProfileReport> <PathToFinalProfileReport> <NumOfMemoryBanks> <LimitConsecutiveAccesses> <LogReadsAndWrites>");
            System.out.println("where:");
            System.out.println("<PathToOriginalProfileReport>: Is the relative path to the input profiling report.");
            System.out.println("<PathToFinalProfileReport>: Is the relative path to the output profiling reports. It will be added an index to each profile");
            System.out.println("<NumOfMemoryBanks>: Is the number of memory banks that have the memory.");
            System.out.println("<LimitConsecutiveAccesses>: For the statistics. To see how many times we exceed the maximum number of consecutive accesses.");
            System.out.println("<LogReadAndWrites>: 0 if dont want to include reads and writes in your splitted profiles. 1 if you do.");
            int i = 0;
            args = new String[5];
            args[i++] = "test2" + File.separator + "vdrift.mem";
            args[i++] = "test2" + File.separator + "vdrift4Rsplitted.profile";
            args[i++] = "4";
            args[i++] = "30";
            args[i++] = "1";
            return;
        }
        String originalProfilePath = args[0];
        String finalProfilePath = args[1];
        int numBanks = Integer.valueOf(args[2]);
        long limit = Long.valueOf(args[3]);
        int logReadsAndWrites = Integer.valueOf(args[4]);
        try {
            SplitProfile generator = new SplitProfile(numBanks, originalProfilePath, finalProfilePath, limit, logReadsAndWrites);
            generator.run();
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }
}

