/*
 * Decompiled with CFR 0.152.
 */
package jeco.dmm.sim2.lib;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.logging.Logger;
import jeco.dmm.sim2.lib.allocator.Allocator;
import jeco.dmm.sim2.lib.allocator.AllocatorComparatorByMaxSize;
import jeco.dmm.sim2.lib.freelist.Block;
import jeco.dmm.sim2.lib.freelist.FreeList;
import jeco.dmm.sim2.util.Metrics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicMemoryManager {
    private static Logger logger = Logger.getLogger(DynamicMemoryManager.class.getName());
    protected Metrics metrics = null;
    protected ArrayList<Allocator> allocators;
    protected long currentPosition = 0L;
    protected HashMap<Long, Block> blocksAllocated = new HashMap();

    public ArrayList<Allocator> getAllocators() {
        return this.allocators;
    }

    public DynamicMemoryManager() {
        this.allocators = new ArrayList();
    }

    public DynamicMemoryManager(Allocator allocator) {
        this();
        this.add(allocator);
    }

    public void add(Allocator allocator) {
        this.allocators.add(allocator);
    }

    public void sortAndFixMinSizes() {
        Collections.sort(this.allocators, new AllocatorComparatorByMaxSize());
        for (int i = 1; i < this.allocators.size(); ++i) {
            this.allocators.get(i).setMinSizeInB(this.allocators.get(i - 1).getMaxSizeInB());
        }
    }

    public Block malloc(long objectId, long sizeInB, Block hottest) {
        this.metrics.incMallocs(1);
        Allocator allocator = null;
        for (Allocator allocatorTemp : this.allocators) {
            this.metrics.addExecutionTime(1L);
            if (!allocatorTemp.canManage(sizeInB)) continue;
            allocator = allocatorTemp;
            break;
        }
        if (allocator != null) {
            Block block = allocator.malloc(sizeInB, hottest);
            if (block.getPosition() >= 0L) {
                this.blocksAllocated.put(objectId, block);
                return block;
            }
            this.metrics.addMemoryUsage(block.getSizeInB());
            return this.virtualMalloc(objectId, block);
        }
        this.metrics.addMemoryUsage(sizeInB);
        return this.virtualMalloc(objectId, new Block(null, -1L, sizeInB));
    }

    public Block free(long objectId) {
        this.metrics.addExecutionTime(1L);
        this.metrics.incFrees(1);
        Block block = this.blocksAllocated.remove(objectId);
        if (block == null) {
            return null;
        }
        FreeList adm = block.getFreeList();
        if (adm != null) {
            adm.free(block);
            return block;
        }
        this.metrics.incFreesLost(1);
        return block;
    }

    private Block virtualMalloc(long objectId, Block block) {
        this.metrics.incMallocsLost(1);
        block.setPosition(this.currentPosition);
        this.blocksAllocated.put(objectId, block);
        this.currentPosition += block.getSizeInB();
        return block;
    }
}

