/*
 * Decompiled with CFR 0.152.
 */
package jeco.dmm.sim2.lib;

import java.io.IOException;
import jeco.dmm.sim2.lib.DynamicMemoryManager;
import jeco.dmm.sim2.lib.Simulator;
import jeco.dmm.sim2.lib.freelist.Block;
import jeco.dmm.sim2.util.ProfilingReport;

public class SimulatorWithReliabilityV1
extends Simulator {
    protected Block lastDelete = null;

    public SimulatorWithReliabilityV1(ProfilingReport profilingReport, DynamicMemoryManager manager, String tracePath) {
        super(profilingReport, manager, tracePath);
    }

    protected void processLine(String line) throws IOException {
        double time = 0.0;
        String opcode = null;
        long objectId = 0L;
        long dataSizeInB = 0L;
        Block block = null;
        String[] parts = line.split(" ");
        time = Double.valueOf(parts[0]);
        opcode = parts[1];
        objectId = Long.valueOf(parts[2]);
        if (objectId < 0L) {
            return;
        }
        if (opcode.equals("new")) {
            dataSizeInB = Long.valueOf(parts[3]);
            if (dataSizeInB <= 0L) {
                return;
            }
            block = this.manager.malloc(objectId, dataSizeInB, this.lastDelete);
            this.lastDelete = null;
        } else if (opcode.equals("delete")) {
            this.lastDelete = block = this.manager.free(objectId);
        } else if (this.tracePath != null && (opcode.equals("read") || opcode.equals("write"))) {
            block = this.manager.blocksAllocated.get(objectId);
        }
        if (this.tracePath != null && block != null) {
            block.setTime(time);
            this.metrics.writeAccess(block.getTime() + " " + block.getPosition());
        }
    }
}

