/*
 * Decompiled with CFR 0.152.
 */
package jeco.dmm.sim2.tools;

import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import jeco.dmm.sim2.util.ProfilingReport;
import jeco.kernel.util.LoggerFormatter;

public class ProfileAnalyzer {
    public void setLevel(Level level) {
        try {
            FileHandler fh = new FileHandler(ProfileAnalyzer.class.getSimpleName() + ".txt", false);
            Logger.getLogger("").addHandler(fh);
        }
        catch (IOException ex) {
            Logger.getLogger(ProfileAnalyzer.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (SecurityException ex) {
            Logger.getLogger(ProfileAnalyzer.class.getName()).log(Level.SEVERE, null, ex);
        }
        Handler[] handlers = Logger.getLogger("").getHandlers();
        for (int index = 0; index < handlers.length; ++index) {
            handlers[index].setLevel(level);
            handlers[index].setFormatter(LoggerFormatter.formatter);
        }
    }

    private void printHelp() {
        System.out.println("Usage:");
        System.out.println("java -jar " + ProfileAnalyzer.class.getSimpleName() + ".jar <PathToProfilingReport>");
        System.out.println("where:");
        System.out.println("<ProfilingReport>: Relative path to the profiling report including malloc/free entries");
    }

    private void analyze(String profPath) {
        try {
            ProfilingReport profilingReport = new ProfilingReport(profPath);
            profilingReport.start();
            profilingReport.join();
        }
        catch (InterruptedException ex) {
            Logger.getLogger(ProfileAnalyzer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void main(String[] args) {
        ProfileAnalyzer analyzer = new ProfileAnalyzer();
        analyzer.setLevel(Level.INFO);
        if (args.length != 1) {
            analyzer.printHelp();
            return;
        }
        analyzer.analyze(args[0]);
    }
}

