/*
 * Decompiled with CFR 0.152.
 */
package jeco.dmm.simulator;

import jeco.dmm.simulator.DMMData;
import jeco.dmm.simulator.DMMLogger;
import jeco.dmm.simulator.headers.AbstractHeader;
import jeco.dmm.simulator.headers.LeaHeader;
import jeco.dmm.simulator.headers.SizeHeader;

public class DMMBlock {
    protected double time;
    protected DMMBlock next;
    protected DMMBlock prev;
    protected DMMBlock nextInHeap;
    protected DMMBlock prevInHeap;
    protected AbstractHeader header;
    protected DMMData dataObject;
    protected float address;
    protected int index;

    public void setTime(double time) {
        this.time = time;
    }

    public double getTime() {
        return this.time;
    }

    public DMMBlock(AbstractHeader header, DMMData dataObject) {
        this.header = header;
        this.dataObject = dataObject;
        this.next = null;
        this.prev = null;
        this.nextInHeap = null;
        this.prevInHeap = null;
        this.index = -1;
    }

    public DMMData getDataObject() {
        DMMLogger.updateData(1L, 1L, 0L, 0L);
        return this.dataObject;
    }

    public void setDataObject(DMMData dataObject) {
        DMMLogger.updateData(1L, 2L, 0L, 0L);
        this.dataObject = dataObject;
    }

    public AbstractHeader getHeader() {
        DMMLogger.updateData(1L, 1L, 0L, 0L);
        return this.header;
    }

    public void setHeader(AbstractHeader header) {
        DMMLogger.updateData(1L, 2L, 0L, 0L);
        this.header = header;
    }

    public long getTotalSizeInBytes() {
        long totalSizeInBytes;
        DMMLogger.updateData(4L, 7L, 0L, 1L);
        long objectSize = this.dataObject.getSizeInBytes();
        if (this.header instanceof LeaHeader) {
            DMMLogger.updateData(1L, 4L, 0L, 1L);
            totalSizeInBytes = (long)((LeaHeader)this.header).getMaxSizeInBytes() + objectSize;
        } else if (this.header instanceof SizeHeader) {
            DMMLogger.updateData(2L, 6L, 0L, 1L);
            totalSizeInBytes = (long)((SizeHeader)this.header).getMaxSizeInBytes() + objectSize;
        } else {
            DMMLogger.updateData(1L, 2L, 0L, 0L);
        }
        totalSizeInBytes = objectSize;
        return totalSizeInBytes;
    }

    public DMMBlock getNext() {
        DMMLogger.updateData(1L, 1L, 0L, 0L);
        return this.next;
    }

    public void setNext(DMMBlock next) {
        DMMLogger.updateData(1L, 2L, 0L, 0L);
        this.next = next;
    }

    public DMMBlock getPrev() {
        DMMLogger.updateData(1L, 1L, 0L, 0L);
        return this.prev;
    }

    public void setPrev(DMMBlock prev) {
        DMMLogger.updateData(1L, 2L, 0L, 0L);
        this.prev = prev;
    }

    public String getDataId() {
        return this.dataObject.getId();
    }

    public DMMBlock getNextInHeap() {
        return this.nextInHeap;
    }

    public void setNextInHeap(DMMBlock nextInHeap) {
        this.nextInHeap = nextInHeap;
    }

    public DMMBlock getPrevInHeap() {
        return this.prevInHeap;
    }

    public void setPrevInHeap(DMMBlock prevInHeap) {
        this.prevInHeap = prevInHeap;
    }

    public void changeId(String id) {
        this.dataObject.setId(id);
    }

    public float getAddress() {
        return this.address;
    }

    public void setAddress(float address) {
        this.address = address;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }
}

