/*
 * Decompiled with CFR 0.152.
 */
package jeco.dmm.simulator.layers.freelists;

import jeco.dmm.simulator.DMMBlock;
import jeco.dmm.simulator.DMMData;
import jeco.dmm.simulator.DMMHeap;
import jeco.dmm.simulator.DMMLogger;
import jeco.dmm.simulator.headers.AbstractHeader;
import jeco.dmm.simulator.layers.freelists.AbstractSLFreeList;

public class FIFOSLBestFitHeap
extends AbstractSLFreeList {
    public FIFOSLBestFitHeap(AbstractHeader header) {
        super(header);
        DMMLogger.updateData(1L, 2L, 0L, 0L);
    }

    public DMMBlock free(DMMData dataObject) {
        DMMLogger.updateData(2L, 5L, 0L, 1L);
        DMMBlock block = DMMHeap.freeBlock(dataObject.getId());
        super.pushBack(block);
        return block;
    }

    public DMMBlock malloc(DMMData dataObject) {
        DMMLogger.updateData(8L, 16L, 0L, 3L);
        long sizeAsked = dataObject.getSizeInBytes();
        DMMBlock bestPrevBlock = null;
        DMMBlock bestBlock = null;
        DMMBlock currentBlock = null;
        long sizeBestBlock = Long.MAX_VALUE;
        boolean firstIteration = true;
        currentBlock = super.getFront();
        while (currentBlock != null) {
            DMMLogger.updateData(3L, 6L, 0L, 1L);
            long sizeToCompare = 0L;
            DMMBlock nextBlock = currentBlock.getNext();
            if (firstIteration) {
                DMMLogger.updateData(1L, 4L, 0L, 2L);
                sizeToCompare = currentBlock.getDataObject().getSizeInBytes();
            } else {
                DMMLogger.updateData(1L, 1L, 0L, 0L);
                if (nextBlock != null) {
                    DMMLogger.updateData(1L, 4L, 0L, 2L);
                    sizeToCompare = nextBlock.getDataObject().getSizeInBytes();
                }
            }
            DMMLogger.updateData(1L, 2L, 0L, 0L);
            if (sizeAsked <= sizeToCompare) {
                DMMLogger.updateData(1L, 3L, 0L, 0L);
                if (bestBlock == null || sizeToCompare < sizeBestBlock) {
                    DMMLogger.updateData(1L, 1L, 0L, 0L);
                    if (firstIteration) {
                        DMMLogger.updateData(3L, 7L, 0L, 2L);
                        bestBlock = currentBlock;
                        bestPrevBlock = null;
                        sizeBestBlock = currentBlock.getDataObject().getSizeInBytes();
                    } else {
                        DMMLogger.updateData(3L, 7L, 0L, 2L);
                        bestBlock = nextBlock;
                        bestPrevBlock = currentBlock;
                        sizeBestBlock = nextBlock.getDataObject().getSizeInBytes();
                    }
                }
            }
            DMMLogger.updateData(1L, 1L, 0L, 0L);
            if (firstIteration) {
                DMMLogger.updateData(1L, 1L, 0L, 0L);
                firstIteration = false;
            } else {
                DMMLogger.updateData(1L, 3L, 0L, 1L);
                currentBlock = currentBlock.getNext();
            }
            DMMLogger.updateData(1L, 1L, 0L, 0L);
        }
        DMMLogger.updateData(1L, 1L, 0L, 0L);
        if (bestBlock != null) {
            DMMLogger.updateData(2L, 9L, 0L, 3L);
            bestBlock = super.remove(bestPrevBlock, bestBlock);
            bestBlock = DMMHeap.changeBlockId(bestBlock, dataObject.getId());
        }
        DMMLogger.updateData(1L, 1L, 0L, 0L);
        return bestBlock;
    }

    public boolean remove(DMMData dataObject) {
        DMMLogger.updateData(3L, 6L, 0L, 1L);
        boolean firstIteration = true;
        for (DMMBlock block = super.getFront(); block != null; block = block.getNext()) {
            DMMLogger.updateData(1L, 1L, 0L, 0L);
            if (firstIteration) {
                DMMLogger.updateData(1L, 5L, 0L, 3L);
                if (dataObject.getId().equals(block.getDataId())) {
                    DMMLogger.updateData(1L, 3L, 0L, 1L);
                    return super.remove(null, block) != null;
                }
            } else {
                DMMLogger.updateData(2L, 5L, 0L, 1L);
                DMMBlock nextBlock = block.getNext();
                if (nextBlock != null) {
                    DMMLogger.updateData(1L, 5L, 0L, 3L);
                    if (dataObject.getId().equals(nextBlock.getDataId())) {
                        DMMLogger.updateData(1L, 4L, 0L, 1L);
                        return super.remove(block, nextBlock) != null;
                    }
                }
            }
            DMMLogger.updateData(2L, 4L, 0L, 1L);
        }
        DMMLogger.updateData(1L, 0L, 0L, 0L);
        return false;
    }
}

