/*
 * Decompiled with CFR 0.152.
 */
package jeco.kernel.operator.comparator;

import java.util.Comparator;
import jeco.kernel.problem.Solution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EpsilonDominanceComparator
implements Comparator<Solution> {
    private double eta;

    public EpsilonDominanceComparator(double eta) {
        this.eta = eta;
    }

    @Override
    public int compare(Solution s1, Solution s2) {
        boolean dominate1 = false;
        boolean dominate2 = false;
        int n = Math.min(s1.getObjectives().length, s2.getObjectives().length);
        for (int i = 0; i < n; ++i) {
            double value2;
            double value1 = s1.getObjective(i);
            int flag = value1 / (1.0 + this.eta) < (value2 = s2.getObjective(i)) ? -1 : (value1 / (1.0 + this.eta) > value2 ? 1 : 0);
            if (flag == -1) {
                dominate1 = true;
            }
            if (flag != 1) continue;
            dominate2 = true;
        }
        if (dominate1 == dominate2) {
            return 0;
        }
        if (dominate1) {
            return -1;
        }
        return 1;
    }
}

