/*
 * Decompiled with CFR 0.152.
 */
package jeco.kernel.operator.selector;

import java.util.Collections;
import jeco.kernel.operator.comparator.SolutionDominance;
import jeco.kernel.problem.Solution;
import jeco.kernel.problem.Solutions;

public class EliteSelectorOperator {
    public static final int DEFAULT_ELITE_SIZE = 10;
    protected int eliteSize;

    public EliteSelectorOperator(int eliteSize) {
        this.eliteSize = eliteSize;
    }

    public EliteSelectorOperator() {
        this(10);
    }

    public Solutions execute(Solutions arg) {
        Solutions solutions = new Solutions();
        solutions.addAll(arg);
        SolutionDominance comparator = new SolutionDominance();
        Collections.sort(solutions, comparator);
        int popSize = solutions.size();
        Solutions eliteSolutions = new Solutions();
        int index = 0;
        while (index < this.eliteSize && index < popSize) {
            Solution solution = ((Solution)solutions.get(index)).clone();
            eliteSolutions.add(solution);
        }
        eliteSolutions.keepParetoNonDominated(comparator);
        return eliteSolutions;
    }
}

