/*
 * Decompiled with CFR 0.152.
 */
package jeco.kernel.qualityIndicators;

import java.util.ArrayList;
import java.util.Collections;
import jeco.kernel.operator.comparator.ObjectiveComparator;
import jeco.kernel.operator.comparator.SolutionDominance;
import jeco.kernel.problem.Solution;
import jeco.kernel.problem.Solutions;
import jeco.kernel.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttainmentSurface {
    protected int dim;
    protected ArrayList<ArrayList<Solutions>> frontsArray = new ArrayList();
    protected double[] maxs;
    protected double[] mins;
    protected int resolution;

    public AttainmentSurface(ArrayList<String> pathsToDataFiles, int resolution) throws Exception {
        for (String filePath : pathsToDataFiles) {
            ArrayList<Solutions> temp = Util.readFrontsFromFile(filePath);
            this.frontsArray.add(temp);
        }
        if (this.frontsArray.size() <= 0) {
            throw new Exception("The number of files is zero or impossible to read.");
        }
        this.dim = Integer.MAX_VALUE;
        for (int i = 0; i < this.frontsArray.size(); ++i) {
            ArrayList<Solutions> fronts = this.frontsArray.get(i);
            if (fronts.size() <= 0) {
                throw new Exception("The number of fronts in the file " + pathsToDataFiles.get(i) + " is zero.");
            }
            int dimAux = ((Solution)fronts.get(0).get(0)).getObjectives().length;
            if (dimAux >= this.dim) continue;
            this.dim = dimAux;
        }
        this.maxs = null;
        this.mins = null;
        this.resolution = resolution;
    }

    public AttainmentSurface(ArrayList<String> pathsToDataFiles) throws Exception {
        this(pathsToDataFiles, 24);
    }

    public void normalize() {
        int i;
        ArrayList<Solutions> totalSet = new ArrayList<Solutions>();
        for (i = 0; i < this.frontsArray.size(); ++i) {
            ArrayList<Solutions> fronts = this.frontsArray.get(i);
            for (Solutions solutions : fronts) {
                totalSet.add(solutions);
            }
        }
        Util.normalize(totalSet, this.dim, 1.0, 2.0);
        this.maxs = new double[this.dim];
        this.mins = new double[this.dim];
        for (i = 0; i < this.dim; ++i) {
            this.maxs[i] = 2.1;
            this.mins[i] = 1.0;
        }
    }

    private void computeReferencePoints() {
        int i;
        this.maxs = new double[this.dim];
        this.mins = new double[this.dim];
        for (i = 0; i < this.dim; ++i) {
            this.maxs[i] = Double.NEGATIVE_INFINITY;
            this.mins[i] = Double.POSITIVE_INFINITY;
        }
        for (i = 0; i < this.frontsArray.size(); ++i) {
            ArrayList<Solutions> fronts = this.frontsArray.get(i);
            for (Solutions solutions : fronts) {
                for (Solution solution : solutions) {
                    for (int j = 0; j < this.dim; ++j) {
                        if (solution.getObjective(j) > this.maxs[j]) {
                            this.maxs[j] = solution.getObjective(j);
                        }
                        if (!(solution.getObjective(j) < this.mins[j])) continue;
                        this.mins[j] = solution.getObjective(j);
                    }
                }
            }
        }
    }

    public ArrayList<Solutions> extractAttainmentSurface(int attainmentSurfaceNumber) {
        ArrayList<Solutions> attainmentSurfaces = new ArrayList<Solutions>();
        for (int i = 0; i < this.frontsArray.size(); ++i) {
            ArrayList<Solutions> fronts = this.frontsArray.get(i);
            Solutions result = new Solutions();
            if (this.maxs == null || this.mins == null) {
                this.computeReferencePoints();
            }
            double[] v = new double[this.dim];
            Solution q = new Solution(this.dim);
            SolutionDominance dominance = new SolutionDominance();
            ObjectiveComparator comparator = new ObjectiveComparator(0);
            for (int k = 0; k < this.dim; ++k) {
                comparator.setObj(k);
                for (int j = 0; j < fronts.size(); ++j) {
                    Solutions solutions = fronts.get(j);
                    Collections.sort(solutions, comparator);
                }
                int count = 0;
                while ((double)count < Math.pow(this.resolution, this.dim - 1)) {
                    int j;
                    int jj = 0;
                    for (j = 0; j < this.dim; ++j) {
                        if (j < k) {
                            jj = j;
                        } else if (j > k) {
                            jj = j - 1;
                        }
                        if (j == k) continue;
                        v[j] = count % (int)Math.pow(this.resolution, jj + 1) / (int)Math.pow(this.resolution, jj);
                        int n = j;
                        v[n] = v[n] / (double)this.resolution;
                    }
                    for (j = 0; j < this.dim; ++j) {
                        if (j == k) continue;
                        q.setObjective(j, this.mins[j] - 0.05 * (this.maxs[j] - this.mins[j]) + v[j] * 1.1 * (this.maxs[j] - this.mins[j]));
                    }
                    ArrayList<Double> inter = new ArrayList<Double>();
                    for (int a = 0; a < fronts.size(); ++a) {
                        Solutions solutions = fronts.get(a);
                        boolean flag = false;
                        int c = 0;
                        while (c < solutions.size()) {
                            Solution solution = (Solution)solutions.get(c);
                            int cc = c++;
                            q.setObjective(k, ((Solution)solutions.get(cc)).getObjective(k));
                            if (dominance.compare(solution, q) >= 0) continue;
                            flag = true;
                            break;
                        }
                        if (!flag) continue;
                        inter.add(q.getObjective(k));
                    }
                    Collections.sort(inter);
                    if (inter.size() > attainmentSurfaceNumber - 1) {
                        q.setObjective(k, (Double)inter.get(attainmentSurfaceNumber - 1));
                        Solution solToAtt = q.clone();
                        result.add(solToAtt);
                    }
                    ++count;
                }
            }
            attainmentSurfaces.add(result);
        }
        return attainmentSurfaces;
    }

    public static void main(String[] args) {
        ArrayList<String> dataPaths = new ArrayList<String>();
        dataPaths.add("D:\\jlrisco\\Trabajo\\MisPapers\\WorkingPapers\\EvolutionaryComputation\\Results\\ZDT1.HNSPSO");
        dataPaths.add("D:\\jlrisco\\Trabajo\\MisPapers\\WorkingPapers\\EvolutionaryComputation\\Results\\ZDT1.NSGAII");
        dataPaths.add("D:\\jlrisco\\Trabajo\\MisPapers\\WorkingPapers\\EvolutionaryComputation\\Results\\ZDT1.NSPSO");
        dataPaths.add("D:\\jlrisco\\Trabajo\\MisPapers\\WorkingPapers\\EvolutionaryComputation\\Results\\ZDT1.OMOPSO");
        dataPaths.add("D:\\jlrisco\\Trabajo\\MisPapers\\WorkingPapers\\EvolutionaryComputation\\Results\\ZDT1.SPEA2");
        try {
            AttainmentSurface att = new AttainmentSurface(dataPaths);
            ArrayList<Solutions> arrayOfSolutions = att.extractAttainmentSurface(1);
            for (int i = 0; i < arrayOfSolutions.size(); ++i) {
                Solutions solutions = arrayOfSolutions.get(i);
                System.out.println("Attainment surface for " + dataPaths.get(i));
                for (Solution solution : solutions) {
                    System.out.println(solution.toString());
                }
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }
}

