/*
 * Decompiled with CFR 0.152.
 */
package jeco.kernel.qualityIndicators;

import java.util.ArrayList;
import jeco.kernel.problem.Solution;
import jeco.kernel.problem.Solutions;
import jeco.kernel.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnaryHyperVolume {
    protected int dim;
    protected double[] nadir;
    ArrayList<ArrayList<Solutions>> fronts = new ArrayList();
    Solutions referenceFront;
    ArrayList<ArrayList<Double>> hyperVolumes;

    public UnaryHyperVolume(ArrayList<String> pathsToDataFiles) throws Exception {
        for (String filePath : pathsToDataFiles) {
            ArrayList<Solutions> temp = Util.readFrontsFromFile(filePath);
            this.fronts.add(temp);
        }
        if (this.fronts.size() <= 0) {
            throw new Exception("The number of files is zero or impossible to read.");
        }
        this.dim = Integer.MAX_VALUE;
        for (int i = 0; i < this.fronts.size(); ++i) {
            ArrayList<Solutions> solutionsSet = this.fronts.get(i);
            if (solutionsSet.size() <= 0) {
                throw new Exception("The number of fronts in the file " + pathsToDataFiles.get(i) + " is zero.");
            }
            int dimAux = ((Solution)solutionsSet.get(0).get(0)).getObjectives().length;
            if (dimAux >= this.dim) continue;
            this.dim = dimAux;
        }
        this.referenceFront = null;
        this.nadir = null;
    }

    public UnaryHyperVolume(ArrayList<String> pathsToDataFiles, String pathToReferenceFront) throws Exception {
        this(pathsToDataFiles);
        this.referenceFront = Util.readFrontFromFile(pathToReferenceFront);
    }

    public void normalize() {
        int i;
        ArrayList<Solutions> totalSet = new ArrayList<Solutions>();
        for (i = 0; i < this.fronts.size(); ++i) {
            ArrayList<Solutions> temp = this.fronts.get(i);
            for (Solutions solutions : temp) {
                totalSet.add(solutions);
            }
        }
        if (this.referenceFront != null) {
            totalSet.add(this.referenceFront);
        }
        Util.normalize(totalSet, this.dim);
        this.nadir = new double[this.dim];
        for (i = 0; i < this.dim; ++i) {
            this.nadir[i] = 2.1;
        }
    }

    private void computeReferencePoints() {
        int j;
        int i;
        this.nadir = new double[this.dim];
        for (i = 0; i < this.dim; ++i) {
            this.nadir[i] = Double.NEGATIVE_INFINITY;
        }
        for (i = 0; i < this.fronts.size(); ++i) {
            ArrayList<Solutions> temp = this.fronts.get(i);
            for (j = 0; j < temp.size(); ++j) {
                Solutions solutions = temp.get(j);
                for (int k = 0; k < solutions.size(); ++k) {
                    Solution solution = (Solution)solutions.get(k);
                    for (int l = 0; l < this.dim; ++l) {
                        if (!(solution.getObjective(l) > this.nadir[l])) continue;
                        this.nadir[l] = solution.getObjective(l);
                    }
                }
            }
        }
        if (this.referenceFront != null) {
            for (i = 0; i < this.referenceFront.size(); ++i) {
                Solution solution = (Solution)this.referenceFront.get(i);
                for (j = 0; j < this.dim; ++j) {
                    if (!(solution.getObjective(j) > this.nadir[j])) continue;
                    this.nadir[j] = solution.getObjective(j);
                }
            }
        }
        for (i = 0; i < this.dim; ++i) {
            this.nadir[i] = this.nadir[i] + 0.1;
        }
    }

    public ArrayList<ArrayList<Double>> calculateHyperVolumes() throws Exception {
        if (this.nadir == null) {
            this.computeReferencePoints();
        }
        this.hyperVolumes = new ArrayList();
        double referenceFrontHyperVolume = 0.0;
        if (this.referenceFront != null) {
            referenceFrontHyperVolume = this.calc_ind_value(this.referenceFront);
        }
        for (int i = 0; i < this.fronts.size(); ++i) {
            ArrayList<Double> aux = new ArrayList<Double>();
            ArrayList<Solutions> solutionsSet = this.fronts.get(i);
            for (int j = 0; j < solutionsSet.size(); ++j) {
                double value = referenceFrontHyperVolume - this.calc_ind_value(solutionsSet.get(j));
                aux.add(value);
            }
            this.hyperVolumes.add(aux);
        }
        return this.hyperVolumes;
    }

    private boolean dominates(double[] point1, double[] point2, int no_objectives) {
        boolean better_in_any_objective = false;
        boolean worse_in_any_objective = false;
        for (int i = 0; i < no_objectives && !worse_in_any_objective; ++i) {
            if (point1[i] > point2[i]) {
                better_in_any_objective = true;
                continue;
            }
            if (!(point1[i] < point2[i])) continue;
            worse_in_any_objective = true;
        }
        return !worse_in_any_objective && better_in_any_objective;
    }

    private boolean weakly_dominates(double[] point1, double[] point2, int no_objectives) {
        boolean worse_in_any_objective = false;
        for (int i = 0; i < no_objectives && !worse_in_any_objective; ++i) {
            if (!(point1[i] < point2[i])) continue;
            worse_in_any_objective = true;
        }
        return !worse_in_any_objective;
    }

    private void swap(Solutions front, int i, int j) {
        Solution tempI = (Solution)front.get(i);
        Solution tempJ = (Solution)front.get(j);
        front.set(i, tempJ);
        front.set(j, tempI);
    }

    private int filter_nondominated_set(Solutions front, int no_points, int no_objectives) {
        int n = no_points;
        block0: for (int i = 0; i < n; ++i) {
            int j = i + 1;
            while (j < n) {
                if (this.dominates(((Solution)front.get(i)).getObjectives(), ((Solution)front.get(j)).getObjectives(), no_objectives)) {
                    this.swap(front, j, --n);
                    continue;
                }
                if (this.dominates(((Solution)front.get(j)).getObjectives(), ((Solution)front.get(i)).getObjectives(), no_objectives)) {
                    this.swap(front, i, --n);
                    --i;
                    continue block0;
                }
                ++j;
            }
        }
        return n;
    }

    private double surface_unchanged_to(Solutions front, int no_points, int objective) throws Exception {
        if (no_points < 1) {
            throw new Exception("Run-time error. no_points must be greater or equal than 1");
        }
        double min = ((Solution)front.get(0)).getObjective(objective);
        for (int i = 1; i < no_points; ++i) {
            double value = ((Solution)front.get(i)).getObjective(objective);
            if (!(value < min)) continue;
            min = value;
        }
        return min;
    }

    int reduce_nondominated_set(Solutions front, int no_points, int objective, double threshold) {
        int n = no_points;
        for (int i = 0; i < n; ++i) {
            if (!(((Solution)front.get(i)).getObjective(objective) <= threshold)) continue;
            this.swap(front, i, --n);
        }
        return n;
    }

    private double calc_hypervolume(Solutions front, int no_points, int no_objectives) throws Exception {
        double volume = 0.0;
        double distance = 0.0;
        int n = no_points;
        while (n > 0) {
            int no_nondominated_points = this.filter_nondominated_set(front, n, no_objectives - 1);
            double temp_vol = 0.0;
            if (no_objectives < 3) {
                if (no_nondominated_points < 1) {
                    throw new Exception("Run-time error. The number of non-dominated points must be greater than zero.");
                }
                temp_vol = ((Solution)front.get(0)).getObjective(0);
            } else {
                temp_vol = this.calc_hypervolume(front, no_nondominated_points, no_objectives - 1);
            }
            double temp_dist = this.surface_unchanged_to(front, n, no_objectives - 1);
            volume += temp_vol * (temp_dist - distance);
            distance = temp_dist;
            n = this.reduce_nondominated_set(front, n, no_objectives - 1, distance);
        }
        return volume;
    }

    private double calc_ind_value(Solutions front) throws Exception {
        for (int i = 0; i < front.size(); ++i) {
            Solution solution = (Solution)front.get(i);
            for (int k = 0; k < this.dim; ++k) {
                double temp = this.nadir[k] - solution.getObjective(k);
                if (temp < 0.0) {
                    throw new Exception("Error in data or reference set file. Reference points must be the anti-optimal values.");
                }
                solution.setObjective(k, temp);
            }
        }
        return this.calc_hypervolume(front, front.size(), this.dim);
    }

    public static void main(String[] args) {
        ArrayList<String> dataPaths = new ArrayList<String>();
        dataPaths.add("D:\\jlrisco\\Trabajo\\MisPapers\\WorkingPapers\\EvolutionaryComputation\\Results\\ZDT1.HNSPSO");
        dataPaths.add("D:\\jlrisco\\Trabajo\\MisPapers\\WorkingPapers\\EvolutionaryComputation\\Results\\ZDT1.NSGAII");
        dataPaths.add("D:\\jlrisco\\Trabajo\\MisPapers\\WorkingPapers\\EvolutionaryComputation\\Results\\ZDT1.NSPSO");
        dataPaths.add("D:\\jlrisco\\Trabajo\\MisPapers\\WorkingPapers\\EvolutionaryComputation\\Results\\ZDT1.OMOPSO");
        dataPaths.add("D:\\jlrisco\\Trabajo\\MisPapers\\WorkingPapers\\EvolutionaryComputation\\Results\\ZDT1.SPEA2");
        String refPath = "D:\\jlrisco\\Trabajo\\MisPapers\\WorkingPapers\\EvolutionaryComputation\\Results\\ZDT1.POF";
        try {
            UnaryHyperVolume hyperVolume = new UnaryHyperVolume(dataPaths, refPath);
            hyperVolume.normalize();
            ArrayList<ArrayList<Double>> volumesSet = hyperVolume.calculateHyperVolumes();
            for (int i = 0; i < volumesSet.size(); ++i) {
                ArrayList<Double> volumes = volumesSet.get(i);
                System.out.println("HyperVolumes for:  " + dataPaths.get(i));
                for (Double volume : volumes) {
                    System.out.println(volume);
                }
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }
}

