/*
 * Decompiled with CFR 0.152.
 */
package jeco.lib.problems.dtlz;

import jeco.kernel.operator.comparator.SolutionDominance;
import jeco.kernel.problem.Solution;
import jeco.kernel.problem.Solutions;
import jeco.kernel.problem.Variable;
import jeco.kernel.problem.VariableReal;
import jeco.lib.problems.dtlz.DTLZ;

public class DTLZ7
extends DTLZ {
    public DTLZ7(Integer numberOfVariables) {
        super("DTLZ7", numberOfVariables);
        for (int i = 0; i < numberOfVariables; ++i) {
            this.lowerBound[i] = 0.0;
            this.upperBound[i] = 1.0;
        }
    }

    public DTLZ7() {
        this(22);
    }

    public void evaluate(Solution solution) {
        int i;
        int k = this.numberOfVariables - this.numberOfObjectives + 1;
        double g = 0.0;
        Variable[] variables = solution.getVariables();
        for (i = this.numberOfVariables - k + 1; i <= this.numberOfVariables; ++i) {
            g += ((Double)((VariableReal)variables[i - 1]).getValue()).doubleValue();
        }
        g = 1.0 + 9.0 * g / (double)k;
        for (i = 1; i <= this.numberOfObjectives - 1; ++i) {
            solution.setObjective(i - 1, (Double)((VariableReal)variables[i - 1]).getValue());
        }
        double h = 0.0;
        double xJ_1 = 0.0;
        for (int j = 1; j <= this.numberOfObjectives - 1; ++j) {
            xJ_1 = (Double)((VariableReal)variables[j - 1]).getValue();
            h += xJ_1 / (1.0 + g) * (1.0 + Math.sin(Math.PI * 3 * xJ_1));
        }
        h = (double)this.numberOfObjectives - h;
        solution.setObjective(this.numberOfObjectives - 1, (1.0 + g) * h);
    }

    public Solutions computeParetoOptimalFront(int n) {
        int num = (int)Math.sqrt(n);
        Solutions result = new Solutions();
        for (int i = 0; i < num; ++i) {
            double x0 = 0.0 + 1.0 * (double)i / (double)(num - 1);
            for (int j = 0; j < num; ++j) {
                Solution sol = new Solution(this);
                double x1 = 0.0 + 1.0 * (double)j / (double)(num - 1);
                sol.getVariable(0).setValue(x0);
                sol.getVariable(1).setValue(x1);
                for (int k = 2; k < this.numberOfVariables; ++k) {
                    sol.getVariable(k).setValue(0.0);
                }
                this.evaluate(sol);
                result.add(sol);
            }
        }
        result.keepParetoNonDominated(new SolutionDominance());
        return result;
    }
}

