/*
 * Decompiled with CFR 0.152.
 */
package jeco.lib.problems.floorplan;

import com.mxgraph.model.mxCell;
import com.mxgraph.model.mxGeometry;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.view.mxGraph;
import javax.swing.JFrame;
import jeco.kernel.problem.Solution;
import jeco.kernel.util.BinaryNode;
import jeco.lib.problems.floorplan.Component;
import jeco.lib.problems.floorplan.PostfixVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Board {
    protected int zoom;

    public Board(int zoom) {
        this.zoom = zoom;
    }

    public void buildBoard(BinaryNode<Component> oneLayer) {
        mxGraph graph = new mxGraph();
        this.buildBoard(oneLayer, graph);
        JFrame frame = new JFrame("BINARY TREE. LAYER: " + oneLayer.getValue().z);
        mxGraphComponent graphComponent = new mxGraphComponent(graph);
        frame.getContentPane().add((java.awt.Component)graphComponent);
        frame.setDefaultCloseOperation(2);
        frame.pack();
        frame.setVisible(true);
    }

    public void buildBoard(Solution solution) {
        for (int layer = 0; layer < solution.getProperty("numLayer").intValue(); ++layer) {
            mxGraph graph = new mxGraph();
            PostfixVariable[] variables = (PostfixVariable[])solution.getVariables();
            for (int i = 0; i < variables.length; ++i) {
                Component currentBlock = variables[i].component;
                if (currentBlock.z != layer || currentBlock.toString().equals("H") || currentBlock.toString().equals("V")) continue;
                double x = currentBlock.x;
                double y = currentBlock.y;
                double l = currentBlock.l;
                double w = currentBlock.w;
                mxCell blockAsCell = new mxCell((Object)currentBlock.toString());
                if (currentBlock.dp < 0.25) {
                    blockAsCell.setStyle("fillColor=blue");
                } else if (currentBlock.dp < 0.5) {
                    blockAsCell.setStyle("fillColor=yellow");
                } else if (currentBlock.dp < 0.75) {
                    blockAsCell.setStyle("fillColor=orange");
                } else {
                    blockAsCell.setStyle("fillColor=red");
                }
                mxGeometry geometry = new mxGeometry(x * (double)this.zoom, y * (double)this.zoom, l * (double)this.zoom, w * (double)this.zoom);
                geometry.setRelative(false);
                blockAsCell.setGeometry(geometry);
                blockAsCell.setVertex(true);
                graph.addCell((Object)blockAsCell, graph.getDefaultParent());
            }
            JFrame frame = new JFrame("SOLUTION. LAYER " + layer);
            mxGraphComponent graphComponent = new mxGraphComponent(graph);
            frame.getContentPane().add((java.awt.Component)graphComponent);
            frame.setDefaultCloseOperation(2);
            frame.pack();
            frame.setVisible(true);
        }
    }

    private void buildBoard(BinaryNode<Component> root, mxGraph graph) {
        if (root == null) {
            return;
        }
        Component rootAsBlock = root.getValue();
        if (rootAsBlock.toString().equals("H") || rootAsBlock.toString().equals("V")) {
            this.buildBoard(root.getLeft(), graph);
            this.buildBoard(root.getRight(), graph);
            return;
        }
        double x = rootAsBlock.x;
        double y = rootAsBlock.y;
        double l = rootAsBlock.l;
        double w = rootAsBlock.w;
        mxCell rootAsCell = new mxCell((Object)rootAsBlock.toString());
        mxGeometry geometry = new mxGeometry(x * (double)this.zoom, y * (double)this.zoom, l * (double)this.zoom, w * (double)this.zoom);
        geometry.setRelative(false);
        rootAsCell.setGeometry(geometry);
        rootAsCell.setVertex(true);
        graph.addCell((Object)rootAsCell, graph.getDefaultParent());
    }
}

