/*
 * Decompiled with CFR 0.152.
 */
package jeco.lib.problems.floorplan;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import jeco.lib.problems.floorplan.Component;
import jeco.lib.problems.floorplan.Coupling;

public class Manager {
    protected ArrayList<Component> components = new ArrayList();
    protected ArrayList<Coupling> couplings = new ArrayList();
    protected String name;
    protected int cellSize;
    protected int maxLength;
    protected int maxWidth;
    protected int maxHeight;

    public Manager(String name, int cellSize, int maxLength, int maxWidth, int maxHeight) {
        this.name = name;
        this.cellSize = cellSize;
        this.maxLength = maxLength / cellSize;
        this.maxWidth = maxWidth / cellSize;
        this.maxHeight = maxHeight;
    }

    public void loadComponents(String pathToFile) throws FileNotFoundException, IOException {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(new File(pathToFile)));
        while ((line = reader.readLine()) != null) {
            if (line.startsWith("#") || line.length() <= 0) continue;
            Component component = new Component(line, this.cellSize);
            this.components.add(component);
        }
    }

    public void loadCouplings(String pathToFile) throws FileNotFoundException, IOException {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(new File(pathToFile)));
        while ((line = reader.readLine()) != null) {
            if (line.startsWith("#") || line.length() <= 0) continue;
            Coupling coupling = new Coupling(line, this.components);
            this.couplings.add(coupling);
        }
    }

    public void saveToDatFile(String datPath) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(new File(datPath)));
        String doubleLine = "//======================================================\n";
        writer.write(doubleLine);
        writer.write("// " + this.name + "\n");
        writer.write(doubleLine);
        writer.write("CellSize = " + this.cellSize + "; // Tama\u00f1o de la celda\n\n");
        writer.write("L = " + this.maxLength + "; // Anchura m\u00e1xima\n\n");
        writer.write("W = " + this.maxWidth + "; // Profundidad m\u00e1xima\n\n");
        writer.write("H = " + this.maxHeight + "; // Altura m\u00e1xima\n\n");
        writer.write("// M\u00f3dulos\n");
        writer.write("Modules = {");
        for (Component component : this.components) {
            writer.write(" <");
            writer.write("" + component.id);
            writer.write(" \"" + component.name + "\"");
            writer.write(" " + component.type);
            writer.write(" 0");
            writer.write(" " + (this.maxLength - component.l));
            writer.write(" 0");
            writer.write(" " + (this.maxWidth - component.w));
            writer.write(" 0");
            writer.write(" " + (this.maxHeight - component.h));
            writer.write(" " + component.l);
            writer.write(" " + component.w);
            writer.write(" " + component.h);
            writer.write(" " + component.p);
            writer.write(">");
        }
        writer.write("};\n\n");
        writer.write("// Cableado entre m\u00f3dulos\n");
        writer.write("Wires = {");
        for (Coupling coupling : this.couplings) {
            writer.write(" <");
            writer.write("" + coupling.componentFrom.id);
            writer.write(" " + coupling.componentTo.id);
            writer.write(">");
        }
        writer.write("};\n\n");
        writer.flush();
        writer.close();
    }

    private double computeWireObj() {
        double result = 0.0;
        for (Coupling coupling : this.couplings) {
            Component compFrom = coupling.componentFrom;
            Component compTo = coupling.componentTo;
            result += (double)(Math.abs(compFrom.x + compFrom.l / 2 - compTo.x - compTo.l / 2) + Math.abs(compFrom.y + compFrom.w / 2 - compTo.y - compTo.w / 2) + Math.abs(compFrom.z + compFrom.h / 2 - compTo.z - compTo.h / 2));
        }
        return result;
    }

    private double computeTempObj() {
        double result = 0.0;
        for (int i = 0; i < this.components.size() - 1; ++i) {
            Component compI = this.components.get(i);
            for (int j = i + 1; j < this.components.size(); ++j) {
                Component compJ = this.components.get(j);
                result += (double)(Math.abs(compI.x + compI.l / 2 - compJ.x - compJ.l / 2) + Math.abs(compI.y + compI.w / 2 - compJ.y - compJ.w / 2) + Math.abs(compI.z + compI.h / 2 - compJ.z - compJ.h / 2)) / (compI.p / (double)(compI.l * compI.w) * (compJ.p / (double)(compJ.l * compJ.w)));
            }
        }
        return result;
    }

    public void saveToXml(String xmlPath) throws IOException {
        int i;
        BufferedWriter writer = new BufferedWriter(new FileWriter(new File(xmlPath)));
        writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
        writer.write("<Floorplan Version=\"3.0\" CellSize=\"" + this.cellSize + "\" L=\"" + this.maxLength + "\" W=\"" + this.maxWidth + "\" H=\"" + this.maxHeight + "\" WireObj=\"" + this.computeWireObj() + "\" TempObj=\"" + this.computeTempObj() + "\" Sum=\"" + (this.computeWireObj() - this.computeTempObj()) + "\">\n");
        writer.write("\t<Blocks>\n");
        for (i = 0; i < this.components.size(); ++i) {
            Component component = this.components.get(i);
            writer.write("\t\t<Block id=\"" + component.id + "\" name=\"" + component.name + "\" type=\"" + component.type + "\" xMin=\"0\" x=\"" + component.x + "\" xMax=\"" + (this.maxLength - component.l) + "\" yMin=\"0\" y=\"" + component.y + "\" yMax=\"" + (this.maxWidth - component.w) + "\" zMin=\"0\" z=\"" + component.z + "\" zMax=\"" + (this.maxHeight - component.h) + "\" l=\"" + component.l + "\" w=\"" + component.w + "\" h=\"" + component.h + "\" p=\"" + component.p + "\"/>\n");
        }
        writer.write("\t</Blocks>\n");
        writer.write("\t<Distances>\n");
        for (i = 0; i < this.components.size() - 1; ++i) {
            Component compI = this.components.get(i);
            for (int j = i + 1; j < this.components.size(); ++j) {
                Component compJ = this.components.get(j);
                writer.write("\t\t<Distance idFrom=\"" + compI.id + "\" idTo=\"" + compJ.id + "\" dx=\"" + Math.abs(compI.x + compI.l / 2 - compJ.x - compJ.l / 2) + "\" dy=\"" + Math.abs(compI.y + compI.w / 2 - compJ.y - compJ.w / 2) + "\" dz=\"" + Math.abs(compI.z + compI.h / 2 - compJ.z - compJ.h / 2) + "\"/>\n");
            }
        }
        writer.write("\t</Distances>\n");
        writer.write("\t<Couplings>\n");
        for (Coupling coupling : this.couplings) {
            writer.write("\t\t<Coupling idFrom=\"" + coupling.componentFrom.id + "\" idTo=\"" + coupling.componentTo.id + "\"/>\n");
        }
        writer.write("\t</Couplings>\n");
        writer.write("</Floorplan>\n");
        writer.flush();
        writer.close();
    }

    public static void main(String[] args) {
        Manager.dcis2010tempWork();
        String dirBase = "D:/jlrisco/Trabajo/Investiga/DavidCuesta/devel/Interfaz-JAVA/benchmarks";
        if (args.length == 0) {
            args = new String[]{"Niagara16cores", dirBase + File.separator + "tempaware0.dat"};
        }
        Manager manager = new Manager(args[0], 300, 9600, 7800, 2);
        try {
            manager.loadComponents(dirBase + File.separator + "Blocks_" + manager.name + ".txt");
            manager.loadCouplings(dirBase + File.separator + "Couplings_" + manager.name + ".txt");
            manager.saveToDatFile(args[1]);
            manager.saveToXml(dirBase + File.separator + args[0] + ".xml");
        }
        catch (IOException ex) {
            Logger.getLogger(Manager.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void dcis2010tempWork() {
        String dirBase = "D:/jlrisco/Trabajo/MisPapers/WorkingPapers/2010_DCIS/Results/Experimentos Ayala";
        String blocksBase = "Blocks_Layout";
        String coupliBase = "Couplings_Layout";
        for (int i = 1; i <= 12; ++i) {
            try {
                String blockBaseFile = blocksBase + i + ".txt";
                String couplingBaseFile = coupliBase + i + ".txt";
                Manager manager = new Manager(blockBaseFile, 300, 9600, 7800, 0);
                manager.loadComponents(dirBase + File.separator + blockBaseFile);
                manager.loadCouplings(dirBase + File.separator + couplingBaseFile);
                System.out.println("Layout " + i + ", WireObj=" + manager.computeWireObj());
                continue;
            }
            catch (Exception ee) {
                System.out.println(ee.toString());
            }
        }
    }
}

