/*
 * Decompiled with CFR 0.152.
 */
package moea.commons;

import ext.number.Value;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import moea.commons.ObjectiveVector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Entity {
    protected static int N;
    protected ObjectiveVector objectiveVector;
    protected boolean scoresValid;
    protected Map<String, Value> properties;

    public abstract void evaluate();

    public Entity() {
        this.objectiveVector = new ObjectiveVector();
        this.scoresValid = false;
        this.properties = new HashMap<String, Value>();
    }

    public Entity(Entity src) {
        this.objectiveVector = new ObjectiveVector(src.objectiveVector);
        this.scoresValid = src.scoresValid;
        this.properties = new HashMap<String, Value>();
        for (Map.Entry<String, Value> entry : src.properties.entrySet()) {
            this.properties.put(entry.getKey(), entry.getValue().clone());
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        ObjectiveVector obj = this.getObjectiveVector();
        for (int i = 0; i < obj.size(); ++i) {
            result.append(obj.get(i) + "\t");
        }
        return result.toString();
    }

    public int compareTo(Entity right, Comparator<Entity> comparator) {
        return comparator.compare(this, right);
    }

    public ObjectiveVector getObjectiveVector() {
        if (!this.scoresValid) {
            this.evaluate();
            this.scoresValid = true;
        }
        return this.objectiveVector;
    }

    public void invalidateScores() {
        this.scoresValid = false;
    }

    public void setProperty(String name, Value value) {
        this.properties.put(name, value);
    }

    public Value getProperty(String name) {
        return this.properties.get(name);
    }

    public static int getN() {
        return N;
    }
}

