/*
 * Decompiled with CFR 0.152.
 */
package moea.commons.assigner;

import ext.number.ValInt;
import ext.number.ValReal;
import ext.number.Value;
import java.util.ArrayList;
import java.util.Collections;
import moea.commons.Entity;
import moea.commons.Individual;
import moea.commons.Population;
import moea.commons.comparator.ComparatorNsga2;
import moea.commons.comparator.ComparatorObjective;
import moea.commons.comparator.ComparatorPareto;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssignerNsga2<I extends Individual> {
    public ArrayList<Population<I>> fastNonDominatedSort(Population<I> pop) {
        Individual qInd;
        int q;
        Population setS;
        Individual pInd;
        int p;
        ArrayList<Population<I>> setsF = new ArrayList<Population<I>>();
        ArrayList<Population> setsS = new ArrayList<Population>();
        for (int i = 0; i < pop.size(); ++i) {
            ((Individual)pop.get(i)).setProperty("n", ValInt.ZERO);
            ((Individual)pop.get(i)).setProperty("rank", ValInt.MAX_VALUE);
            ((Individual)pop.get(i)).setProperty("crowdingDistance", ValReal.ZERO);
        }
        Population setF = new Population();
        for (p = 0; p < pop.size(); ++p) {
            pInd = (Individual)pop.get(p);
            setS = new Population();
            for (q = 0; q < pop.size(); ++q) {
                qInd = (Individual)pop.get(q);
                int compare = pInd.compareTo(qInd, ComparatorPareto.getInstance());
                if (compare == -1) {
                    setS.add(qInd);
                    continue;
                }
                if (compare != 1) continue;
                pInd.setProperty("n", pInd.getProperty("n").add(new ValInt(1)));
            }
            if (pInd.getProperty("n").equals(ValInt.ZERO)) {
                setF.add(pInd);
            }
            pInd.setProperty("indexS", new ValInt(p));
            setsS.add(setS);
        }
        int rank = 1;
        while (setF.size() > 0) {
            Population setH = new Population();
            for (p = 0; p < setF.size(); ++p) {
                pInd = (Individual)setF.get(p);
                pInd.setProperty("rank", new ValInt(rank));
                setS = (Population)setsS.get(pInd.getProperty("indexS").getValue().intValue());
                for (q = 0; q < setS.size(); ++q) {
                    qInd = (Individual)setS.get(q);
                    qInd.setProperty("n", qInd.getProperty("n").substract(new ValInt(1)));
                    if (!qInd.getProperty("n").equals(ValInt.ZERO)) continue;
                    setH.add(qInd);
                }
            }
            setsF.add(setF);
            setF = setH;
            ++rank;
        }
        return setsF;
    }

    public void crowdingDistanceAssignment(Population<I> pop) {
        int i;
        int l = pop.size();
        for (i = 0; i < l; ++i) {
            ((Individual)pop.get(i)).setProperty("crowdingDistance", ValReal.ZERO);
        }
        for (int m = 0; m < Entity.getN(); ++m) {
            Collections.sort(pop, ComparatorObjective.getInstance(m));
            ((Individual)pop.get(0)).setProperty("crowdingDistance", ValReal.MAX_VALUE);
            ((Individual)pop.get(l - 1)).setProperty("crowdingDistance", ValReal.MAX_VALUE);
            for (i = 1; i < l - 1; ++i) {
                Value temp = ((Individual)pop.get(i)).getProperty("crowdingDistance");
                temp = temp.add(new ValReal((Double)((Individual)pop.get(i + 1)).getObjectiveVector().get(m)));
                temp = temp.substract(new ValReal((Double)((Individual)pop.get(i - 1)).getObjectiveVector().get(m)));
                ((Individual)pop.get(i)).setProperty("crowdingDistance", temp);
            }
        }
    }

    public Population<I> reduce(Population<I> pop, int maxSize) {
        Population<I> reducedPop = new Population<I>();
        ArrayList<Population<I>> setsF = this.fastNonDominatedSort(pop);
        for (int i = 0; reducedPop.size() < maxSize && i < setsF.size(); ++i) {
            Population<I> setF = setsF.get(i);
            this.crowdingDistanceAssignment(setF);
            reducedPop.add(setF);
        }
        if (reducedPop.size() > maxSize) {
            Collections.sort(reducedPop, ComparatorNsga2.getInstance());
            while (reducedPop.size() > maxSize) {
                reducedPop.remove(reducedPop.size() - 1);
            }
        }
        return reducedPop;
    }
}

