/*
 * Decompiled with CFR 0.152.
 */
package moea.moga.algorithms;

import java.util.ArrayList;
import java.util.Collections;
import moea.commons.Population;
import moea.commons.comparator.ComparatorObjective;
import moea.commons.comparator.ComparatorPareto;
import moea.moga.examples.ChowPaper;
import moea.moga.examples.ChowPaperThreaded;
import moea.moga.genome.Chromosome;
import moea.moga.selector.Selector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Moea
extends Thread {
    protected String name;
    protected int currentGeneration;
    protected int maxGenerations;
    protected Population<Chromosome> pop;
    protected int popSizeMax;
    protected double probabilityOfCrossover;
    protected double probabilityOfMutation;
    protected Selector selector;
    protected int migrationRate;
    protected ArrayList<Moea> neighbors;
    protected ArrayList<Chromosome> externalIndividuals;
    protected boolean threadPaused;

    public Moea(String name, Population<Chromosome> popIni, int maxGenerations, double probabilityOfCrossover, double probabilityOfMutation, int migrationRate) {
        this.name = name;
        this.currentGeneration = 0;
        this.maxGenerations = maxGenerations;
        this.popSizeMax = popIni.size();
        this.pop = popIni;
        this.probabilityOfCrossover = probabilityOfCrossover;
        this.probabilityOfMutation = probabilityOfMutation;
        this.migrationRate = migrationRate;
        this.neighbors = new ArrayList();
        this.externalIndividuals = new ArrayList();
        this.threadPaused = false;
    }

    public Moea(String name, Population<Chromosome> popIni, int maxGenerations, double probabilityOfCrossover, double probabilityOfMutation) {
        this(name, popIni, maxGenerations, probabilityOfCrossover, probabilityOfMutation, 1);
    }

    public Population<Chromosome> generate(Population<Chromosome> pop) {
        Population<Chromosome> result = new Population<Chromosome>();
        this.selector.update(pop);
        Chromosome mom = this.selector.select();
        Chromosome dad = this.selector.select();
        while (mom != null && dad != null) {
            Chromosome sister = mom.clone();
            Chromosome brother = dad.clone();
            mom.crossover(this.probabilityOfCrossover, dad, sister, brother);
            sister.mutate(this.probabilityOfMutation);
            brother.mutate(this.probabilityOfMutation);
            result.add(sister);
            result.add(brother);
            mom = this.selector.select();
            dad = this.selector.select();
        }
        return result;
    }

    public boolean done() {
        return this.currentGeneration >= this.maxGenerations;
    }

    public int getCurrentGeneration() {
        return this.currentGeneration;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Algorithm: ");
        buffer.append(this.getClass().getName());
        buffer.append(", Current generation: ");
        buffer.append(this.currentGeneration);
        buffer.append("\n");
        buffer.append("Selection strategy: ");
        buffer.append(this.selector.getClass().getName());
        buffer.append("\n");
        buffer.append("Current population size: ");
        buffer.append(this.pop.size());
        buffer.append("\n");
        buffer.append("<--- Scores information on generation ");
        buffer.append(this.currentGeneration);
        buffer.append(" --->\n");
        buffer.append("In population 1:\n");
        buffer.append(this.pop.toString());
        return buffer.toString();
    }

    public String exportToMatFile() {
        return this.pop.toString();
    }

    public Population<Chromosome> getPopulation() {
        return this.pop;
    }

    public abstract void step();

    @Override
    public void run() {
        while (!this.done()) {
            if (!this.threadPaused) {
                this.step();
            }
            if (this.currentGeneration % 100 != 0 || this.neighbors.size() <= 0 || this.currentGeneration <= 0) continue;
            Population<Chromosome> popToSend = this.filter(this.pop, this.migrationRate);
            this.send(popToSend);
        }
    }

    public Population<Chromosome> filter(Population<Chromosome> pop, int num) {
        Population<Chromosome> sortedPop = new Population<Chromosome>();
        sortedPop.add(pop);
        sortedPop.keepNonDominated();
        Collections.sort(sortedPop, ComparatorObjective.getInstance((int)(Math.random() * (double)Chromosome.getN())));
        Population<Chromosome> newPop = new Population<Chromosome>();
        for (int i = 0; i < num; ++i) {
            if (i >= sortedPop.size()) continue;
            newPop.add(((Chromosome)sortedPop.get(i)).clone());
        }
        return newPop;
    }

    public void addNeighbor(Moea neighbor) {
        this.neighbors.add(neighbor);
    }

    public synchronized void send(Population<Chromosome> population) {
        for (Moea neighbor : this.neighbors) {
            while (neighbor.currentGeneration < this.currentGeneration) {
                try {
                    this.wait(20L);
                }
                catch (Exception ee) {
                    System.out.println("Sleep exception.");
                }
            }
            neighbor.receive(population);
        }
    }

    public boolean gameOver() {
        return ChowPaperThreaded.genToMaxThread < Integer.MAX_VALUE;
    }

    public void receive(Population<Chromosome> population) {
        for (Chromosome individual : population) {
            this.externalIndividuals.add(individual);
        }
    }

    public synchronized void pauseEvolution() {
        this.threadPaused = true;
    }

    public synchronized void resumeEvolution() {
        this.threadPaused = false;
    }

    public synchronized void terminateEvolution() {
        this.currentGeneration = Integer.MAX_VALUE;
    }

    public void updateGenToMax() {
        Chromosome ind = this.getPopulation().getBestIndividual(ComparatorPareto.getInstance());
        double value = (Double)ind.getObjectiveVector().get(0);
        if (ChowPaper.isOptimal(value) && this.currentGeneration < ChowPaperThreaded.genToMaxThread) {
            ChowPaperThreaded.genToMaxThread = this.currentGeneration;
        }
    }
}

