/*
 * Decompiled with CFR 0.152.
 */
package moea.moga.algorithms;

import moea.commons.Population;
import moea.commons.assigner.AssignerNsga2;
import moea.commons.comparator.ComparatorNsga2;
import moea.moga.algorithms.Moea;
import moea.moga.genome.Chromosome;
import moea.moga.selector.BinarySelector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Nsga2
extends Moea {
    protected AssignerNsga2<Chromosome> assigner;

    public Nsga2(String name, Population<Chromosome> popIni, int maxGenerations, double probabilityOfCrossover, double probabilityOfMutation, int migrationRate) {
        super(name, popIni, maxGenerations, probabilityOfCrossover, probabilityOfMutation, migrationRate);
        this.selector = new BinarySelector(ComparatorNsga2.getInstance());
        this.assigner = new AssignerNsga2();
    }

    public Nsga2(String name, Population<Chromosome> popIni, int maxGenerations, double probabilityOfCrossover, double probabilityOfMutation) {
        this(name, popIni, maxGenerations, probabilityOfCrossover, probabilityOfMutation, 1);
    }

    @Override
    public void step() {
        if (this.currentGeneration == 0) {
            this.assigner.fastNonDominatedSort(this.pop);
            ++this.currentGeneration;
            return;
        }
        Population<Chromosome> childPop = this.generate(this.pop);
        Population<Chromosome> mixedPop = new Population<Chromosome>();
        mixedPop.add(this.pop);
        mixedPop.add(childPop);
        int extSize = this.externalIndividuals.size();
        if (extSize > 0) {
            for (int i = 0; i < extSize; ++i) {
                mixedPop.add(this.externalIndividuals.get(i));
            }
            this.externalIndividuals.clear();
        }
        this.pop = this.assigner.reduce(mixedPop, this.popSizeMax);
        ++this.currentGeneration;
    }
}

