/*
 * Decompiled with CFR 0.152.
 */
package moea.moga.examples;

import ext.number.ValModPosInt;
import ext.number.Value;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.Map;
import moea.commons.Population;
import moea.commons.comparator.ComparatorPareto;
import moea.moga.algorithms.Moea;
import moea.moga.algorithms.Vega;
import moea.moga.genome.Chromosome;
import moea.moga.genome.ChromosomeWithMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChowPaperCont
extends ChromosomeWithMapping {
    private static final long serialVersionUID = 1L;
    protected static KindOfFunction kindOfFunction;
    protected static int numTrials;
    protected static int K;
    protected static double xRL;
    protected static double xRU;
    protected static double epsilon;

    @Override
    public ChowPaperCont clone() {
        ChowPaperCont clone = new ChowPaperCont(this);
        return clone;
    }

    public ChowPaperCont() {
    }

    public ChowPaperCont(ChowPaperCont src) {
        super(src);
    }

    public static void initializeProblem(String[] args) throws Exception {
        String function = args[0];
        epsilon = Double.valueOf(args[3]);
        N = 1;
        if (function.equals("RASTRINGIN")) {
            xRL = -5.12;
            xRU = 5.12;
            K = (int)Math.ceil(ChowPaperCont.log2((xRU - xRL + epsilon) / epsilon));
            M = 20 * K;
            kindOfFunction = KindOfFunction.RASTRINGIN;
        } else if (function.equals("SCHWEFEL")) {
            xRL = -500.0;
            xRU = 500.0;
            K = (int)Math.ceil(ChowPaperCont.log2((xRU - xRL + epsilon) / epsilon));
            M = 10 * K;
            kindOfFunction = KindOfFunction.SCHWEFEL;
        } else if (function.equals("TRAP4")) {
            M = (int)epsilon;
            K = 4;
            kindOfFunction = KindOfFunction.TRAP4;
        } else if (function.equals("TRAP8")) {
            M = (int)epsilon;
            K = 8;
            kindOfFunction = KindOfFunction.TRAP8;
        } else if (function.equals("UGLY")) {
            M = (int)epsilon;
            K = 4;
            kindOfFunction = KindOfFunction.UGLY;
        } else if (function.equals("BAD")) {
            M = (int)epsilon;
            K = 4;
            kindOfFunction = KindOfFunction.BAD;
        } else {
            throw new Exception("First argument wrong");
        }
        try {
            ValModPosInt.setModulus(2);
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        xL = new Value[M];
        xU = new Value[M];
        for (int j = 0; j < M; ++j) {
            ChowPaperCont.xL[j] = new ValModPosInt(0);
            ChowPaperCont.xU[j] = new ValModPosInt(1);
        }
        String optimization = args[4];
        mappingMethod = optimization.equals("GA") ? ChromosomeWithMapping.MappingMethod.NONE : (optimization.equals("EMM") ? ChromosomeWithMapping.MappingMethod.EMM : ChromosomeWithMapping.MappingMethod.EMMRS);
    }

    @Override
    public void evaluate() {
        for (int i = 0; i < N; ++i) {
            this.objectiveVector.set(i, 0.0);
        }
        double f = 0.0;
        double[] xReal = null;
        switch (kindOfFunction) {
            case RASTRINGIN: {
                f = 0.0;
                xReal = this.decodeToReal();
                for (int i = 0; i < xReal.length; ++i) {
                    f += xReal[i] * xReal[i] - 10.0 * Math.cos(Math.PI * 2 * xReal[i]) + 10.0;
                }
                break;
            }
            case SCHWEFEL: {
                f = 0.0;
                xReal = this.decodeToReal();
                for (int i = 0; i < xReal.length; ++i) {
                    f -= xReal[i] * Math.sin(Math.sqrt(Math.abs(xReal[i])));
                }
                f += 4189.828872721624;
                break;
            }
            case TRAP4: 
            case TRAP8: {
                f = this.ftrap(1);
                f += (double)M;
                break;
            }
            case UGLY: 
            case BAD: {
                int groups = M / K;
                double acumulador = 0.0;
                int[] auxiliar = new int[4];
                for (int i = 0; i < groups; ++i) {
                    for (int j = 0; j < 4; ++j) {
                        auxiliar[j] = mappingMethod != ChromosomeWithMapping.MappingMethod.NONE ? this.x[this.mapping[groups * j + i]].intValue() : this.x[groups * j + i].intValue();
                    }
                    int valorDecimal = 0;
                    int base2 = 1;
                    for (int m = 3; m >= 0; --m) {
                        valorDecimal += auxiliar[m] * base2;
                        base2 *= 2;
                    }
                    if (kindOfFunction == KindOfFunction.UGLY) {
                        acumulador += ChowPaperCont.ugly(valorDecimal);
                        continue;
                    }
                    acumulador += ChowPaperCont.bad(valorDecimal);
                }
                f = 30.0 * (double)M / 4.0 - acumulador;
            }
        }
        this.objectiveVector.set(0, f);
    }

    public double[] decodeToReal() {
        int numVar = M / K;
        double[] xReal = null;
        xReal = new double[numVar];
        int jIni = 0;
        int k = 0;
        for (int i = 0; i < numVar; ++i) {
            double xRi = 0.0;
            for (int j = jIni = i * K; j < jIni + K; ++j) {
                k = j - jIni;
                int xi = mappingMethod != ChromosomeWithMapping.MappingMethod.NONE ? this.x[this.mapping[j]].intValue() : this.x[j].intValue();
                if (xi != 1) continue;
                xRi += Math.pow(2.0, k);
            }
            xReal[i] = xRi = xRL + xRi * (xRU - xRL) / (Math.pow(2.0, K) - 1.0);
        }
        return xReal;
    }

    public static void printStats(BufferedWriter out, int[] array, Map<Integer, Double> mapFit, Map<Integer, Integer> mapFitCount) throws Exception {
        int optimalValues = 0;
        int generations = 0;
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == 0) continue;
            ++optimalValues;
            generations += array[i];
        }
        double avg = 1.0 * (double)generations / (double)optimalValues;
        double std = 0.0;
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == 0) continue;
            std += Math.pow((double)array[i] - avg, 2.0);
        }
        out.write("Optimal values: " + optimalValues + "/" + array.length + "\n");
        out.write("Avg. Generations: " + avg + ", Std:" + Math.sqrt(std /= (double)optimalValues) + "\n");
        for (Map.Entry<Integer, Double> entry : mapFit.entrySet()) {
            out.write(entry.getKey() + "\t" + entry.getValue() / (double)mapFitCount.get(entry.getKey()).intValue() + "\n");
        }
    }

    public static void main(String[] args) throws Exception {
        String outDir = ".";
        if (args.length != 6) {
            args = new String[]{"TRAP8", "10000", "200", "160", "GA", "100"};
            System.out.println("Arguments: Function Evaluations Size Precision/Bits MappingMode Step");
            System.out.println("Recommended: [RASTRINGIN|SCHWEFEL|TRAP4|TRAP8|UGLY|BAD] 10001 200 [1e-6|1e-6|80|160|40-60|40-60] [GA|EMM|EMMRS] 100");
            outDir = "D:/jlrisco/Trabajo/MisPapers/GECCO/2008/Results";
        }
        ChowPaperCont.initializeProblem(args);
        System.out.println("Chromosome length: " + M);
        Integer maxGenerations = Integer.valueOf(args[1]);
        Integer popSize = Integer.valueOf(args[2]);
        Integer step = Integer.valueOf(args[5]);
        for (int i = 0; i < numTrials; ++i) {
            BufferedWriter out = new BufferedWriter(new FileWriter(new File(outDir + File.separator + args[0] + "_" + args[1] + "_" + args[2] + "_" + args[3].replaceAll("-", "") + "_" + args[4] + "." + i)));
            System.out.println("Iteration number: " + i + "...");
            Population<Chromosome> popIni = new Population<Chromosome>();
            for (int k = 0; k < popSize; ++k) {
                ChowPaperCont individual = new ChowPaperCont();
                popIni.add(individual);
            }
            Vega algorithm = new Vega("VEGA", popIni, maxGenerations, 0.9, 1.0 / (double)M);
            int t = 0;
            boolean isOptimal = false;
            double value = 0.0;
            while (!algorithm.done() && !isOptimal) {
                t = algorithm.getCurrentGeneration();
                Chromosome ind = algorithm.getPopulation().getBestIndividual(ComparatorPareto.getInstance());
                value = (Double)ind.getObjectiveVector().get(0);
                isOptimal = ChowPaperCont.isOptimal(value);
                if (t % step == 0 || isOptimal) {
                    System.out.println("\tCurrent generation: " + t + ", Fitness: " + value);
                    out.write(t + "\t" + value + "\n");
                }
                ((Moea)algorithm).step();
            }
            System.out.println("done with optimal at generation: " + t);
            out.flush();
            out.close();
        }
    }

    public double ftrap(int d) {
        int numVar = M / K;
        double res = 0.0;
        int ones = 0;
        int jIni = 0;
        for (int i = 0; i < numVar; ++i) {
            jIni = i * K;
            ones = 0;
            for (int j = jIni; j < jIni + K; ++j) {
                int xi = mappingMethod != ChromosomeWithMapping.MappingMethod.NONE ? this.x[this.mapping[j]].intValue() : this.x[j].intValue();
                if (xi != 1) continue;
                ++ones;
            }
            if (ones == K) {
                res += (double)K;
                continue;
            }
            res += (double)(K - ones - d);
        }
        return -res;
    }

    public static boolean isOptimal(double fitness) {
        boolean isOptimal = false;
        switch (kindOfFunction) {
            case RASTRINGIN: {
                if (!(Math.abs(fitness) <= epsilon)) break;
                isOptimal = true;
                break;
            }
            case SCHWEFEL: {
                if (!(Math.abs(fitness) <= epsilon)) break;
                isOptimal = true;
                break;
            }
            case TRAP4: 
            case TRAP8: 
            case UGLY: 
            case BAD: {
                if (fitness != 0.0) break;
                isOptimal = true;
            }
        }
        return isOptimal;
    }

    public static double log2(double value) {
        return Math.log(value) / Math.log(2.0);
    }

    public static double bad(int parametro) {
        double res = 0.0;
        switch (parametro) {
            case 0: {
                res = 18.0;
                break;
            }
            case 1: {
                res = 6.0;
                break;
            }
            case 2: {
                res = 26.0;
                break;
            }
            case 3: {
                res = 16.0;
                break;
            }
            case 4: {
                res = 24.0;
                break;
            }
            case 5: {
                res = 14.0;
                break;
            }
            case 6: {
                res = 28.0;
                break;
            }
            case 7: {
                res = 20.0;
                break;
            }
            case 8: {
                res = 4.0;
                break;
            }
            case 9: {
                res = 30.0;
                break;
            }
            case 10: {
                res = 12.0;
                break;
            }
            case 11: {
                res = 0.0;
                break;
            }
            case 12: {
                res = 10.0;
                break;
            }
            case 13: {
                res = 2.0;
                break;
            }
            case 14: {
                res = 22.0;
                break;
            }
            case 15: {
                res = 8.0;
                break;
            }
            default: {
                res = 0.0;
            }
        }
        return res;
    }

    public static double ugly(int parametro) {
        double res = 0.0;
        switch (parametro) {
            case 0: {
                res = 28.0;
                break;
            }
            case 1: {
                res = 26.0;
                break;
            }
            case 2: {
                res = 24.0;
                break;
            }
            case 3: {
                res = 18.0;
                break;
            }
            case 4: {
                res = 22.0;
                break;
            }
            case 5: {
                res = 16.0;
                break;
            }
            case 6: {
                res = 14.0;
                break;
            }
            case 7: {
                res = 0.0;
                break;
            }
            case 8: {
                res = 20.0;
                break;
            }
            case 9: {
                res = 12.0;
                break;
            }
            case 10: {
                res = 10.0;
                break;
            }
            case 11: {
                res = 2.0;
                break;
            }
            case 12: {
                res = 8.0;
                break;
            }
            case 13: {
                res = 4.0;
                break;
            }
            case 14: {
                res = 6.0;
                break;
            }
            case 15: {
                res = 30.0;
                break;
            }
            default: {
                res = 0.0;
            }
        }
        return res;
    }

    static {
        numTrials = 10;
        K = 0;
        xRL = 0.0;
        xRU = 0.0;
        epsilon = 1.0E-6;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum KindOfFunction {
        RASTRINGIN,
        SCHWEFEL,
        TRAP4,
        TRAP8,
        UGLY,
        BAD;

    }
}

