/*
 * Decompiled with CFR 0.152.
 */
package moea.moga.examples;

import ext.number.ValModPosInt;
import ext.number.Value;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import moea.commons.ObjectiveVector;
import moea.commons.Population;
import moea.moga.algorithms.Moea;
import moea.moga.algorithms.Nsga2;
import moea.moga.algorithms.Spea2;
import moea.moga.algorithms.Vega;
import moea.moga.genome.Chromosome;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Profile
extends Chromosome {
    private static final long serialVersionUID = 1L;
    public static final int AR = 0;
    public static final int ARP = 1;
    public static final int SLL = 2;
    public static final int DLL = 3;
    public static final int SLLO = 4;
    public static final int DLLO = 5;
    public static final int SLLAR = 6;
    public static final int DLLAR = 7;
    public static final int SLLARO = 8;
    public static final int DLLARO = 9;
    public static final String[] ddts = new String[]{"AR", "AR(P)", "SLL", "DLL", "SLL(O)", "DLL(O)", "SLL(AR)", "DLL(AR)", "SLL(ARO)", "DLL(ARO)"};
    public static double cacheAccessTime;
    public static double dramAccessTime;
    public static double cacheLineSize;
    public static double dramBandwith;
    public static double cpuPower;
    public static double cacheAccessEnergy;
    public static double dramAccessPower;
    public static long[] Ne;
    public static double[] NeSd;
    public static double[] Nve;
    public static int Na;
    public static double[] Nn;
    public static int[] Te;
    public static int Tref;
    public static long[][] readsPerDdt;
    public static long[][] writesPerDdt;
    public static long[] readsPlusWritesPerDdt;
    public static double[][] cacheMissesL1;

    public static void initializeProblem(String proPath) {
        cacheAccessTime = 1.0E-7;
        dramAccessTime = 1.0E-6;
        cacheLineSize = 32.0;
        dramBandwith = 5.0E7;
        cpuPower = 0.019;
        cacheAccessEnergy = 1.0E-4;
        dramAccessPower = 0.001;
        Element xmlProfileAnalyzer = null;
        try {
            File file = new File(proPath);
            if (!file.exists()) {
                throw new Exception("The file path does not exist.");
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document docApplication = builder.parse(file.toURI().toString());
            xmlProfileAnalyzer = (Element)docApplication.getElementsByTagName("ProfileAnalyzer").item(0);
            N = 3;
            M = Profile.loadScalarAsInteger(xmlProfileAnalyzer, "VarCount");
            Tref = Profile.loadScalarAsInteger(xmlProfileAnalyzer, "Tref");
            Na = Profile.loadScalarAsInteger(xmlProfileAnalyzer, "Na");
            Ne = Profile.loadArrayAsLong(xmlProfileAnalyzer, "Ne");
            NeSd = Profile.loadArrayAsDouble(xmlProfileAnalyzer, "NeSd");
            Nve = Profile.loadArrayAsDouble(xmlProfileAnalyzer, "Nve");
            Nn = Profile.loadArrayAsDouble(xmlProfileAnalyzer, "Nn");
            Te = Profile.loadArrayAsInteger(xmlProfileAnalyzer, "Te");
            readsPerDdt = Profile.loadMatrixAsLong(xmlProfileAnalyzer, "ReadsPerDdt");
            writesPerDdt = Profile.loadMatrixAsLong(xmlProfileAnalyzer, "WritesPerDdt");
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        Profile.updateCacheMisses();
        try {
            ValModPosInt.setModulus(10);
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        xL = new Value[M];
        xU = new Value[M];
        for (int j = 0; j < M; ++j) {
            Profile.xL[j] = new ValModPosInt(0);
            Profile.xU[j] = new ValModPosInt(9);
        }
    }

    public static int loadScalarAsInteger(Element xmlProfileAnalyzer, String scalarName) {
        int scalar = 0;
        Element xmlNode = (Element)xmlProfileAnalyzer.getElementsByTagName(scalarName).item(0);
        scalar = Integer.valueOf(xmlNode.getAttribute("Value"));
        return scalar;
    }

    public static int[] loadArrayAsInteger(Element xmlProfileAnalyzer, String arrayName) {
        Element xmlNode = (Element)xmlProfileAnalyzer.getElementsByTagName(arrayName).item(0);
        int size = Integer.valueOf(xmlNode.getAttribute("Size"));
        int[] array = new int[size];
        NodeList xmlItemList = xmlNode.getElementsByTagName("Item");
        for (int i = 0; i < size; ++i) {
            int value;
            Element xmlItem = (Element)xmlItemList.item(i);
            int index = Integer.valueOf(xmlItem.getAttribute("Index"));
            array[index] = value = Integer.valueOf(xmlItem.getAttribute("Value")).intValue();
        }
        return array;
    }

    public static long[] loadArrayAsLong(Element xmlProfileAnalyzer, String arrayName) {
        Element xmlNode = (Element)xmlProfileAnalyzer.getElementsByTagName(arrayName).item(0);
        int size = Integer.valueOf(xmlNode.getAttribute("Size"));
        long[] array = new long[size];
        NodeList xmlItemList = xmlNode.getElementsByTagName("Item");
        for (int i = 0; i < size; ++i) {
            long value;
            Element xmlItem = (Element)xmlItemList.item(i);
            int index = Integer.valueOf(xmlItem.getAttribute("Index"));
            array[index] = value = Long.valueOf(xmlItem.getAttribute("Value")).longValue();
        }
        return array;
    }

    public static double[] loadArrayAsDouble(Element xmlProfileAnalyzer, String arrayName) {
        Element xmlNode = (Element)xmlProfileAnalyzer.getElementsByTagName(arrayName).item(0);
        int size = Integer.valueOf(xmlNode.getAttribute("Size"));
        double[] array = new double[size];
        NodeList xmlItemList = xmlNode.getElementsByTagName("Item");
        for (int i = 0; i < size; ++i) {
            double value;
            Element xmlItem = (Element)xmlItemList.item(i);
            int index = Integer.valueOf(xmlItem.getAttribute("Index"));
            array[index] = value = Double.valueOf(xmlItem.getAttribute("Value")).doubleValue();
        }
        return array;
    }

    public static long[][] loadMatrixAsLong(Element xmlProfileAnalyzer, String matrixName) {
        Element xmlNode = (Element)xmlProfileAnalyzer.getElementsByTagName(matrixName).item(0);
        int rows = Integer.valueOf(xmlNode.getAttribute("Rows"));
        int columns = Integer.valueOf(xmlNode.getAttribute("Columns"));
        long[][] matrix = new long[rows][columns];
        NodeList xmlItemList = xmlNode.getElementsByTagName("Item");
        for (int i = 0; i < xmlItemList.getLength(); ++i) {
            long value;
            Element xmlItem = (Element)xmlItemList.item(i);
            int row = Integer.valueOf(xmlItem.getAttribute("Row"));
            int column = Integer.valueOf(xmlItem.getAttribute("Column"));
            matrix[row][column] = value = Long.valueOf(xmlItem.getAttribute("Value")).longValue();
        }
        return matrix;
    }

    public static void updateCacheMisses() {
        int j;
        int i;
        readsPlusWritesPerDdt = new long[ddts.length];
        for (i = 0; i < ddts.length; ++i) {
            Profile.readsPlusWritesPerDdt[i] = 0L;
        }
        for (i = 0; i < ddts.length; ++i) {
            for (j = 0; j < M; ++j) {
                int n = i;
                readsPlusWritesPerDdt[n] = readsPlusWritesPerDdt[n] + (readsPerDdt[j][i] + writesPerDdt[j][i]);
            }
        }
        cacheMissesL1 = new double[M][ddts.length];
        for (i = 0; i < M; ++i) {
            for (j = 0; j < ddts.length; ++j) {
                Profile.cacheMissesL1[i][j] = 1.0 * NeSd[i] * (double)readsPlusWritesPerDdt[j] / (double)(readsPlusWritesPerDdt[j] + readsPerDdt[i][j] + writesPerDdt[i][j]);
            }
        }
    }

    public Profile() {
    }

    public Profile(Value[] x) {
        this.x = x;
    }

    public Profile(Profile src) {
        super(src);
    }

    @Override
    public Profile clone() {
        Profile clone = new Profile(this);
        return clone;
    }

    @Override
    public void evaluate() {
        for (int i = 0; i < 3; ++i) {
            this.objectiveVector.set(i, 0.0);
        }
        double performance = 0.0;
        double memory = 0.0;
        double energy = 0.0;
        double randomCount = 0.0;
        double secuentialCount = 0.0;
        double averageSize = 0.0;
        double numCreations = 0.0;
        double reads = 0.0;
        double writes = 0.0;
        double execTime = 0.0;
        for (int i = 0; i < M; ++i) {
            int ddt = this.x[i].intValue();
            randomCount = 0.0;
            secuentialCount = 0.0;
            averageSize = 0.0;
            numCreations = 0.0;
            reads = readsPerDdt[i][ddt];
            writes = writesPerDdt[i][ddt];
            execTime = 0.0;
            if (ddt == 0) {
                secuentialCount = 9L * Ne[i];
                randomCount = 2.0;
                averageSize = (long)(19 * Tref) + Ne[i] * (long)Te[i];
                numCreations = 1.0;
            } else if (ddt == 1) {
                secuentialCount = 10L * Ne[i];
                randomCount = 3.0;
                averageSize = (long)(19 * Tref) + Ne[i] * (long)(Tref + Te[i]);
                numCreations = 1.0 + Nve[i];
            } else if (ddt == 2) {
                secuentialCount = 7L * Ne[i];
                randomCount = Ne[i] / 2L + 1L;
                averageSize = (long)(19 * Tref) + Ne[i] * (long)(2 * Tref + Te[i]);
                numCreations = 1.0 + Nve[i];
            } else if (ddt == 3) {
                secuentialCount = 7L * Ne[i];
                randomCount = Ne[i] / 4L + 1L;
                averageSize = (long)(19 * Tref) + Ne[i] * (long)(3 * Tref + Te[i]);
                numCreations = 1.0 + Nve[i];
            } else if (ddt == 4) {
                secuentialCount = 10L * Ne[i];
                randomCount = Ne[i] / 3L + 1L;
                averageSize = (long)(20 * Tref) + Ne[i] * (long)(2 * Tref + Te[i]);
                numCreations = 1.0 + Nve[i];
            } else if (ddt == 5) {
                secuentialCount = 10L * Ne[i];
                randomCount = Ne[i] / 6L + 1L;
                averageSize = (long)(20 * Tref) + Ne[i] * (long)(3 * Tref + Te[i]);
                numCreations = 1.0 + Nve[i];
            } else if (ddt == 6) {
                secuentialCount = 18L * Ne[i] + (long)(8 * Na);
                randomCount = Nn[i] / 2.0 + 1.0;
                averageSize = (double)(21 * Tref) + Nn[i] * (double)((long)(21 * Tref) + Ne[i] * (long)(Te[i] + Tref));
                numCreations = (double)(2L * Ne[i]) + Nve[i];
            } else if (ddt == 7) {
                secuentialCount = 18L * Ne[i] + (long)(8 * Na);
                randomCount = Nn[i] / 4.0 + 1.0;
                averageSize = (double)(21 * Tref) + Nn[i] * (double)((long)(22 * Tref) + Ne[i] * (long)(Te[i] + Tref));
                numCreations = (double)(2L * Ne[i]) + Nve[i];
            } else if (ddt == 8) {
                secuentialCount = 18L * Ne[i] + (long)(10 * Na);
                randomCount = Nn[i] / 3.0 + 1.0;
                averageSize = (double)(22 * Tref) + Nn[i] * (double)((long)(21 * Tref) + Ne[i] * (long)(Te[i] + Tref));
                numCreations = (double)(2L * Ne[i]) + Nve[i];
            } else if (ddt == 9) {
                secuentialCount = 18L * Ne[i] + (long)(10 * Na);
                randomCount = Nn[i] / 6.0 + 1.0;
                averageSize = (double)(22 * Tref) + Nn[i] * (double)((long)(22 * Tref) + Ne[i] * (long)(Te[i] + Tref));
                numCreations = (double)(2L * Ne[i]) + Nve[i];
            }
            performance += 1.0E-5 * (randomCount * (3.0 * (reads + writes - 2.0) / 4.0) + secuentialCount * ((reads + writes - 2.0) / 4.0) + 2.0 * numCreations);
            memory += averageSize;
            execTime = (reads + writes) * (1.0 - cacheMissesL1[i][ddt]) * cacheAccessTime + (reads + writes) * cacheMissesL1[i][ddt] * dramAccessTime + (reads + writes) * cacheMissesL1[i][ddt] * cacheLineSize * (1.0 / dramBandwith);
            energy += execTime * cpuPower + (reads + writes) * (1.0 - cacheMissesL1[i][ddt]) * cacheAccessEnergy + (reads + writes) * cacheMissesL1[i][ddt] * cacheAccessEnergy * cacheLineSize + (reads + writes) * cacheMissesL1[i][ddt] * dramAccessPower * (dramAccessTime + cacheLineSize / dramBandwith);
        }
        this.objectiveVector.set(0, performance);
        this.objectiveVector.set(1, memory);
        this.objectiveVector.set(2, energy);
    }

    public static void main(String[] args) throws Exception {
        String outDir = ".";
        if (args.length < 5) {
            System.out.println("Usage:");
            System.out.println("java -jar Profile.jar <XML-PROFILE> <VEGA|SPEA2|NSGA2> <NumTrials:1..Inf> <NumOfIndividuals:1..Inf> <MaxGenerations:1..Inf> <UniformAnalysis:true|false>");
            args = new String[]{"Physics.pro", "VEGA", "0", "200", "4000", "true"};
            outDir = "D:/jlrisco/Trabajo/MisPapers/IEEE T EVOLUT COMPUT/2007/Results";
            return;
        }
        String proPath = outDir + File.separator + args[0];
        String algorithmName = args[1];
        Integer numberOfTrials = Integer.valueOf(args[2]);
        Integer numberOfIndividuals = Integer.valueOf(args[3]);
        Integer maxGenerations = Integer.valueOf(args[4]);
        Boolean uniformAnalysis = false;
        if (args.length > 5) {
            uniformAnalysis = Boolean.valueOf(args[5]);
        }
        Profile.initializeProblem(proPath);
        BufferedWriter loggerMetrics = new BufferedWriter(new FileWriter(new File(proPath + "." + algorithmName + ".MetricsAvg")));
        ArrayList<Double> spreads = new ArrayList<Double>();
        ArrayList<Double> spacings = new ArrayList<Double>();
        ArrayList<Double> times = new ArrayList<Double>();
        Moea algorithm = null;
        for (int i = 0; i < numberOfTrials; ++i) {
            BufferedWriter loggerPop = new BufferedWriter(new FileWriter(new File(proPath + "." + algorithmName + "." + i)));
            System.out.println("Iteration number: " + i);
            Population<Chromosome> popIni = new Population<Chromosome>();
            for (int k = 0; k < numberOfIndividuals; ++k) {
                Profile ind = new Profile();
                popIni.add(ind);
            }
            if (algorithmName.equals("VEGA")) {
                algorithm = new Vega("Vega", popIni, maxGenerations, 0.8, 0.01);
            } else if (algorithmName.equals("SPEA2")) {
                algorithm = new Spea2("Spea2", popIni, maxGenerations, 0.8, 0.01);
            } else if (algorithmName.equals("NSGA2")) {
                algorithm = new Nsga2("Nsga2", popIni, maxGenerations, 0.8, 0.01);
            }
            double start = System.currentTimeMillis();
            while (!algorithm.done()) {
                if (algorithm.getCurrentGeneration() % 100 == 0) {
                    System.out.println("Current generation: " + algorithm.getCurrentGeneration());
                }
                algorithm.step();
            }
            double end = System.currentTimeMillis();
            spreads.add(algorithm.getPopulation().calculateSpread());
            spacings.add(algorithm.getPopulation().calculateSpacing());
            times.add((end - start) / 1000.0);
            System.out.println("Spread: " + spreads.get(spreads.size() - 1));
            System.out.println("Spacing: " + spacings.get(spacings.size() - 1));
            System.out.println("Time: " + (end - start) / 1000.0);
            System.out.println("done.");
            loggerPop.write(Profile.ParetoFrontToString(algorithm.getPopulation()));
            loggerPop.flush();
            loggerPop.close();
        }
        if (uniformAnalysis.booleanValue()) {
            Profile.saveUniformObjectives(proPath);
        }
        double spreadMean = Profile.calculateMean(spreads);
        double spacingMean = Profile.calculateMean(spacings);
        double timeMean = Profile.calculateMean(times);
        double spreadStd = Profile.calculateStd(spreads, spreadMean);
        double spacingStd = Profile.calculateStd(spacings, spacingMean);
        double timeStd = Profile.calculateStd(times, timeMean);
        loggerMetrics.write("Spread(Mean,Std):\t" + spreadMean + "\t" + spreadStd + "\n");
        loggerMetrics.write("Spacing(Mean,Std):\t" + spacingMean + "\t" + spacingStd + "\n");
        loggerMetrics.write("Time(Mean,Std):\t" + timeMean + "\t" + timeStd + "\n");
        loggerMetrics.flush();
        loggerMetrics.close();
    }

    public static double calculateMean(ArrayList<Double> list) {
        double res = 0.0;
        for (Double d : list) {
            res += d.doubleValue();
        }
        return res /= (double)list.size();
    }

    public static double calculateStd(ArrayList<Double> list, double mean) {
        double res = 0.0;
        for (Double d : list) {
            res += Math.pow(d - mean, 2.0);
        }
        res = Math.sqrt(res / (double)(list.size() - 1));
        return res;
    }

    public static String ParetoFrontToString(Population<Chromosome> pop) {
        StringBuffer buffer = new StringBuffer();
        Population<Chromosome> popTemp = new Population<Chromosome>();
        popTemp.add(pop);
        popTemp.keepNonDominated();
        for (Chromosome chrom : popTemp) {
            ObjectiveVector objs = chrom.getObjectiveVector();
            for (int i = 0; i < N; ++i) {
                buffer.append(objs.get(i) + "\t");
            }
            buffer.append("\n");
        }
        return buffer.toString();
    }

    public static String PopulationToString(Population<Chromosome> pop) {
        StringBuffer buffer = new StringBuffer();
        for (Chromosome chrom : pop) {
            ObjectiveVector objs = chrom.getObjectiveVector();
            for (int i = 0; i < N; ++i) {
                buffer.append(objs.get(i) + "\t");
            }
            buffer.append("\n");
        }
        return buffer.toString();
    }

    public static void saveUniformObjectives(String proPath) throws Exception {
        StringBuffer buffer = new StringBuffer();
        BufferedWriter out = new BufferedWriter(new FileWriter(new File(proPath + ".UniformAnalysis")));
        Value[] xTemp = new Value[M];
        for (int d = 0; d < ddts.length; ++d) {
            for (int i = 0; i < M; ++i) {
                xTemp[i] = new ValModPosInt(d);
            }
            Profile temp = new Profile(xTemp);
            temp.evaluate();
            ObjectiveVector objs = temp.getObjectiveVector();
            for (int i = 0; i < N; ++i) {
                buffer.append(objs.get(i) + "\t");
            }
            buffer.append("\n");
        }
        for (int i = 0; i < M; ++i) {
            xTemp[i] = new ValModPosInt((int)((double)ddts.length * Math.random()));
        }
        Profile temp = new Profile(xTemp);
        temp.evaluate();
        ObjectiveVector objs = temp.getObjectiveVector();
        for (int i = 0; i < N; ++i) {
            buffer.append(objs.get(i) + "\t");
        }
        buffer.append("\n");
        out.write(buffer.toString());
        out.flush();
        out.close();
    }

    public static int getSubPopSize(int popSize, int numThreads) {
        if (numThreads == 1) {
            return popSize;
        }
        double ratio = 1.0 * (double)popSize / (double)numThreads;
        return (int)Math.round(ratio + 2.0 / (double)numThreads * ((double)popSize - ratio));
    }

    public static int getMigrationRate(int popSize) {
        if (popSize < 100) {
            return 1;
        }
        return (int)Math.round(1.0 * (double)popSize / 100.0);
    }
}

